from types import SimpleNamespace
from torch import nn
import torch
from pathlib import Path

# ModelNet40 dataset path

processed_data_path = Path(".../modelnet40_ply_hdf5_2048")
epoch = 600
warmup = 60
batch_size = 32
learning_rate = 2e-3
label_smoothing = 0.2

dsconv_args = SimpleNamespace()
dsconv_args.depths = [4, 4, 4]
dsconv_args.ns = [1024, 256, 64]
dsconv_args.ks = [20, 20, 20]
dsconv_args.dims = [96, 192, 384]
dsconv_args.nbr_dims = [48, 48]  
dsconv_args.bottleneck = 2048
dsconv_args.num_classes = 40
drop_path = 0.15
drop_rates = torch.linspace(0., drop_path, sum(dsconv_args.depths)).split(dsconv_args.depths)
dsconv_args.drop_paths = [dpr.tolist() for dpr in drop_rates]
dsconv_args.bn_momentum = 0.1
dsconv_args.act = nn.GELU
dsconv_args.mlp_ratio = 2
dsconv_args.cor_std = [2.8, 5.3, 10]
