For DSConv-XXL, we utilize the training code of DeLA for the training process. The specific environment configuration can be set up following the steps below. We have provided the training code and training logs on all datasets for your reference, and the specific code will be open-sourced in the future.

The specific training log is in the pretrained directory under each dataset folder directory, such as ScanNetV2/pretrained/log.txt.

### utils 

**cutils** contains cpp/cuda functions (neighbor edge-max-pooling, grid subsampling, knn search).

**util.py** has some python functions (state saving/loading, metric calculation).

**timm** is a tiny [timm](https://github.com/rwightman/pytorch-image-models). Only functions used are kept to reduce dependencies.

**pointnet2_ops_lib** is from [Pointnet2_PyTorch](https://github.com/erikwijmans/Pointnet2_PyTorch).

### other directories

Dataset specific implementation.

Basically all contain: train, test, config, model, dataset, readme.md and pretrained (folder containing training log and trained model).

Please be aware that the code used to train our pretrained models has been (and likely will be) slightly amended, so you may notice discrepancies in the training log. (currently only fixed reset of corls)



## Dependency

We list libraries (tested version) and the way we install it for reference.

We believe newer versions are generally fine and there's no need to follow this guide exactly.

### General dependency

Create and activate environment using [conda](https://docs.conda.io/projects/conda/en/latest/user-guide/install/).

Add [conda-forge](https://conda-forge.org/index.html) channel to the environment first and comment the original channels.

Switch mirrors (channel sources) if necessary. 

```bash
conda create -n dela python=3.10

conda activate dela
```

Install pytorch.

Specify a version with cuda.

```bash
conda install pytorch=1.13.1=cuda112py310he33e0d6_200
```

Other tools should be automatically installed in this step, e.g., numpy (1.24.3), cudatoolkit (11.8.0), ...

An important thing to note is, as of 2023.5, under this setting, llvm-openmp >= 16.0.0 can cause a problem with pytorch's multi threaded dataloading.

We currently do not know the exact cause, and simply use version 15.

```bash
conda install llvm-openmp=15
```

Then check if cuda kernels can be compiled smoothly.

Remember to set CUDA_HOME and TORCH_CUDA_ARCH_LIST properly.

```bash
python
Python 3.10.11 | packaged by conda-forge | (main, May 10 2023, 18:58:44) [GCC 11.3.0] on linux
Type "help", "copyright", "credits" or "license" for more information.
>>> from utils.cutils import knn_edge_maxpooling
```

Compilation verbose is set to True and can be disabled in line 15 of cutils' init file if this step goes fine.

### Classification dependency

Install h5py.

```bash
conda install h5py=3.8.0
```

Install pointnet2_ops.

```bash
cd utils/pointnet2_ops_lib/
pip install .
```

### Part segmentation dependency

Install pointnet2_ops.

```bash
cd utils/pointnet2_ops_lib/
pip install .
```

### ScanNet v2 dependency

Install plyfile and scipy.

```bash
conda install plyfile=0.8.1 scipy=1.10.1
```



## Train & test

To train & test on a specific dataset, first enter corresponding directory and **set up the dataset following readme.md**.

### Train

```bash
python train.py
```

Saved logs and models are under output/.

Check train.py and other scripts for more details. 

To resume from a checkpoint, follow train.py (search for "resume").

### Test

```bash
python test.py
```

As random seeds are not fixed, output for segmentation is slightly unstable.

The results of pretrained models should be near reported ones with high probability.


