#!/usr/bin/env python
# coding: utf-8
import __init__
import os
from openpoints.dataset.vis3d import read_obj, vis_multi_points

#67  12.66 **
#61  10.2
#58  10.37 **
#51  9.19
#48  16.91 **
#45  18.98 **
#30  17.25
#31  9.18
#22  10.12 **
#20  15.99
#15  9.54
#14  19.42  **
#2   12.36
# --------------------------------
idx = 58
data_dir = "/media/zxm/data/pointconvnext/visualization"
data_dir_low = "/media/zxm/data/pointnext/visualization"
dataset_name = 's3dis-Area5'
roof_height = 3
# --------------------------------

method_names = ['input', 'gt','pointnext-xl']
file_list = []
colors_list = []
for i, method_name in enumerate(method_names):
    file_path = os.path.join(data_dir, f'{method_name}-{dataset_name}-{idx}.obj')
    points, colors =read_obj(file_path)
    if i == 0: # input
        # remove roof
        valid_idx = points[:, 2] < roof_height 
        input_points = points[valid_idx]
        #print(colors[valid_idx])
        colors_list.append(colors[valid_idx])
    else:
        tmp = colors[valid_idx,2]*0.8+0.2
        colors[valid_idx,2] = colors[valid_idx,1]
        colors[valid_idx, 1] = tmp
        colors_list.append(colors[valid_idx])
a = colors_list.pop()
file_path = os.path.join(data_dir_low, f'{method_names[2]}-{dataset_name}-{idx}.obj')
points, colors =read_obj(file_path)
tmp = colors[valid_idx,2]*0.8+0.2
colors[valid_idx,2] = colors[valid_idx,1]
colors[valid_idx, 1] = tmp
colors_list.append(colors[valid_idx])
colors_list.append(a)


points_list = [input_points] * (len(method_names)+1)
vis_multi_points(points_list, colors_list)