
def z_order_encoding(x, y, z):
    # 将x、y、z坐标转换为整数形式
    x_int = int(x * 100)  # 乘以一个适当的倍数以增大整数范围
    y_int = int(y * 100)
    z_int = int(z * 100)

    # 使用位运算进行Z-Order编码
    result = 0
    for i in range(32):  # 假设使用32位编码
        result |= (x_int & 1 << i) << (3 * i) | (y_int & 1 << i) << (3 * i + 1) | (z_int & 1 << i) << (3 * i + 2)

    return result

# 示例
x_coordinate = 1.0
y_coordinate = 3.4
z_coordinate = 3.1

z_order_code = z_order_encoding(x_coordinate, y_coordinate, z_coordinate)
print(f"Z-Order编码值: {z_order_code}")