# Appendix

Please read full paper with appendix by opening full_paper.pdf

# Installation

To run this code, install the conda environment from `environment.yml`:

```
conda env create -f environment.yml
```

# Datasets and checkpoints

Please follow these instructions to evaluated our checkpoints or use the datasets to train the model:

1. Create two folders for datasets and checkpoints, and assign environment variables DATASETS and CKPTS to their paths, respectively
1. Download the datasets and checkpoint using gsutil: `gsutil cp ckpts.tar gs://rf-transformer/datasets.tar .`, same command for `ckpts.tar`
1. Extract the tar files into the newly created directories.

# Evaluation

1. The config for the checkpoint is embedded in the ckpt file. One of the config components is the path to the tokenizer, which can change. The CommSignal3 checkpoint uses tokenizer "token179.ckpt", others use "token025.ckpt". To change the tokenizer path in a checkpoint, run:

```
python -m compat.fix_ckpt_path path_to_src.ckpt path_to_dst.ckpt path_to_tokenizer.ckpt
```

Then, use the new generated ckpt file.

To evalute and reproduce four results we present for four datasets, run the following commands:

```
python eval.py $CKPTS/cs3.ckpt $DATASETS/test/cs3 --expansion multidiff --multidiff_step 640
python eval.py $CKPTS/cs5g1.ckpt $DATASETS/test/cs5g1 --expansion multidiff --multidiff_step 640
python eval.py $CKPTS/emi.ckpt $DATASETS/test/emi --expansion multidiff --multidiff_step 640
python eval.py $CKPTS/cs2.ckpt $DATASETS/test/cs2
```

# Training

To re-run training, run the script (as an example):

```
python run_train.py --gpu 0,1 --config cs5g1_qllm_2560_new [--testmode]
```
