import ml_collections
from enum import Enum


class ModelType(Enum):
    WINDOWS = 0
    QUANTIZED = 1
    QUANTIZED_LLM = 2
    WINDOWS_LLM = 3
    WAVENET = 4


def get_config():
    config = ml_collections.ConfigDict()

    config.trainer_config = ml_collections.ConfigDict(
        dict(
            model_dir="",
            distributed=False,
            world_size=1,
            num_workers=0,
            warmup_steps=4000,
            max_steps=1_000_000,
            batch_size=16,
            train_fraction=0.8,
            clip_max_norm=1.0,
            fp16=False,
            bf16=False,
            log_every=50,
            save_every=25000,
            validate_every=1000,
        )
    )

    config.lr_scheduler_config = [
        "IdentityScheduler",
        ml_collections.ConfigDict(dict()),
    ]

    config.test_datasets = []
    config.test_every_epochs = 10

    config.beam_k = 1
    config.ber_sync = 16
    config.model_type = ModelType.WINDOWS
    config.quantize_input = False
    config.testmode = False

    # (metric, maximize)
    config.ckpt_metrics = [("val/loss", False)]
    config.soi_type = "old"

    return config
