import argparse
import os

def main():
    parser = argparse.ArgumentParser(description='Run torchrun with GPU and config options.')
    parser.add_argument('--gpu', type=str, required=True, help='Comma-separated list of GPU IDs (for CUDA_VISIBLE_DEVICES)')
    parser.add_argument('--config', type=str, required=True, help='Path to the configuration file')
    parser.add_argument('--testmode', action="store_true")
    
    args = parser.parse_args()
    os.environ["CUDA_VISIBLE_DEVICES"] = args.gpu
    command = f"torchrun --standalone --nproc_per_node={len(args.gpu.split(','))} main_torchrun.py --trainer=transformer_decoder_torchrun --config=configs/{args.config}.py" + (" --testmode" if args.testmode else "")
    print(f"Running command: {command}")
    os.system(command)

if __name__ == "__main__":
    main()
