import os
import numpy as np

from scripts.gen_test import mix_testset


def main():
    root_dir = os.environ["DATASETS"]
    for signal in ["cs2", "cs3", "cs5g1", "emi"]:
        for ts_id in [1, 2, "val"]:
            interference = f"ts{ts_id}_int/{signal}" if isinstance(ts_id, int) else f"{signal}/interference"
            target = f"mix_test{ts_id}" if isinstance(ts_id, int) else "mix_test_val"
            print("mix_test", signal, ts_id)
            mix_testset(soi=os.path.join(root_dir, "qpsk_new/test"),
                        interference=os.path.join(root_dir, interference),
                        target=os.path.join(root_dir, f"{signal}_new", target),
                        sinrs=np.linspace(-30.0, 0.0, 11).tolist(),
                        signal_length=40960,
                        sync_soi_by=1,
                        use_rand_phase=True,
                        ber_sync=16)



if __name__ == "__main__":
    main()
