import urllib.parse
import urllib
import uuid
import os
import shutil
from PIL import Image, ImageFilter, ImageChops
import numpy as np
from enum import Enum
import requests
import base64
from functools import lru_cache
import itertools
from tqdm import tqdm
import json
import re
import pickle

def path_append(path: str, name: str):
    return path.rstrip('/\\') + '/' + name.lstrip('/\\')


def extract_blocks(text):
    """
    Extracts triple backtick blocks from a string
    """
    return re.findall(r'```([^`]+)```', text)


def extract_and_classify_blocks(text, langs=['python','json']):
    """
    Extracts triple backtick blocks from a string and classifies them by language
    """
    blocks = extract_blocks(text)
    return {lang: [b[len(lang):].strip() for b in blocks if b.startswith(lang)] for lang in langs}


def extract_python_from_llava_output(response_paths, generated_code_dir, lang='python', model_name='llava', rep='DSL', skip_first_line=True):
    print('file num:', len(response_paths))
    os.makedirs(generated_code_dir, exist_ok=True)
    
    for p in response_paths:
        with open(p, 'r') as f:
            text = f.read()
        if skip_first_line:
            text = text.split('\n', 1)[1]
        blocks = extract_and_classify_blocks(text)
        if len(blocks[lang]) != 1:
            reason = 'BadModelOutput'
            code = "}}BAD GENERATION{{" # This will break the parser and show up in our results
        else:
            code = blocks[lang][0]
        example_code = p.split('/')[-2].split('-')[-1]
        code_file_name = model_name + '_' + example_code + ('.py' if lang == 'python' else '.json')
        code_file_path = path_append(generated_code_dir, model_name + '/' + rep + '/' + code_file_name)
        os.makedirs(os.path.dirname(code_file_path), exist_ok=True)
        with open(code_file_path,'w') as f:
            f.write(code)


def parse_simulation_results(success_dir):
    pkl_file = os.path.join(success_dir, 'success_metrics.pkl')
    with open(pkl_file, 'rb') as f:
        success_metrics = pickle.load(f)

    sim_results = {}
    for item in success_metrics:
        codeid = item['example_code']
        pred_sim_results = item['metrics']['pred_sim_results']
        gt_sim_results = item['metrics']['gt_sim_results']
        
        sim_results[codeid] = {
            'pred_sim_results': pred_sim_results,
            'gt_sim_results': gt_sim_results
        }
    
    return sim_results
        
