MID_RUN_NAME=${1:-"llavanext-lora-omni-wsysprompt"}
DATA_PATH=${2:-"data/llava_train_v3_omni.yaml"}
IMG_FOLDER=${3:-"/data/metagen-data/v3/images/"}
BASE_MODEL="lmms-lab/llama3-llava-next-8b"

VISION_MODEL_VERSION="openai/clip-vit-large-patch14-336"

############### Pretrain ################
PORT=${PORT:-"29529"}

deepspeed --include localhost:0,1,2,3,4,5,6,7 --master_port=${PORT} llava/train/train_mem.py \
    --deepspeed scripts/zero3.json \
    --lora_enable True --lora_r 16 --lora_alpha 32 --mm_projector_lr 2e-5 \
    --model_name_or_path ${BASE_MODEL} \
    --version llava_llama_3 \
    --data_path ${DATA_PATH} \
    --image_folder ${IMG_FOLDER} \
    --vision_tower ${VISION_MODEL_VERSION} \
    --mm_projector_type mlp2x_gelu \
    --mm_vision_select_layer -2 \
    --mm_use_im_start_end False \
    --mm_use_im_patch_token False \
    --group_by_modality_length True \
    --image_aspect_ratio anyres \
    --image_grid_pinpoints "[(336, 672), (672, 336), (672, 672), (1008, 336), (336, 1008)]" \
    --mm_patch_merge_type spatial_unpad \
    --bf16 True \
    --run_name $MID_RUN_NAME \
    --output_dir "checkpoints/${MID_RUN_NAME}/" \
    --num_train_epochs 1 \
    --per_device_train_batch_size 2 \
    --per_device_eval_batch_size 1 \
    --gradient_accumulation_steps 1 \
    --evaluation_strategy "no" \
    --save_strategy "steps" \
    --save_steps 500 \
    --save_total_limit 10 \
    --learning_rate 1e-5 \
    --weight_decay 0. \
    --warmup_ratio 0.03 \
    --lr_scheduler_type "cosine" \
    --logging_steps 1 \
    --tf32 True \
    --model_max_length 32768 \
    --gradient_checkpointing True \
    --dataloader_num_workers 16 \
    --lazy_preprocess True \
    --report_to wandb \
    --attn_implementation sdpa \
    --change_system_prompt True \
    --vocab_size_overwrite 128256 \
    --is_dslv3_format True

# You can delete the sdpa attn_implementation if you want to use flash attn