from datetime import date

class DSLTranslator_Formatter:
    def __init__(self):
        self.__head_comment = {
            "file_info": {
                "author": "DSLTranslator",
                "date": date.today(),
                "metagen_version": "",
                "autogenerated": True,
                "generator_info": {
                    "script": "",
                    "settings": {
                        "generator_config": {},
                        "structure_details": {}
                    }
                }
            },
            "structure_info": {
                "alternate_names": [],
                "related_structures": [],
                "tags": {
                    "geometry": [],
                    "characteristic_properties": [],
                    "characteristic_applications": []
                },
                "symmetry": {
                    "crystal_system": "",
                    "bravais_lattice": "",
                    "point_group": "", 
                    "space_group": ""
                }
            },
            "sources": [], 
            "generator_settings": [],
            "notes": []
        }
        self.__exposed_design_parameter_list = []


    # =============================================
    #       Setting header info
    # =============================================
    def set_file_info(self, _metagen_version:str, _generator_filepath:str, _generator_config:dict) -> None:
        self.__head_comment["file_info"]["metagen_version"] = _metagen_version
        self.__head_comment["file_info"]["generator_info"]["script"] = _generator_filepath
        self.__head_comment["file_info"]["generator_info"]["settings"]["generator_config"] = _generator_config

    def set_structure_details(self, _structure_details:dict) -> None:
        self.__head_comment["file_info"]["generator_info"]["settings"]["structure_details"] = _structure_details

    def overwrite_structure_info(self, _structure_info:dict) -> None:
        self.__head_comment["structure_info"] = _structure_info

    def set_structure_tags(self, _tags_geo:list[str], _tags_char_props:list[str], _tags_char_apps:list[str]) -> None:
        self.__head_comment["structure_info"]["tags"]["geometry"] = _tags_geo
        self.__head_comment["structure_info"]["tags"]["characteristic_properties"] = _tags_char_props
        self.__head_comment["structure_info"]["tags"]["characteristic_applications"] = _tags_char_apps

    def set_symmetry_info(self, _symmetry_crystal_system:str, _sym_bravais_lattice:str, _sym_point_group:str, _sym_space_group:str) -> None:
        self.__head_comment["structure_info"]["symmetry"]["crystal_system"] = _symmetry_crystal_system
        self.__head_comment["structure_info"]["symmetry"]["bravais_lattice"] = _sym_bravais_lattice
        self.__head_comment["structure_info"]["symmetry"]["point_group"] = _sym_point_group
        self.__head_comment["structure_info"]["symmetry"]["space_group"] = _sym_space_group

    def add_related_structure(self, related_structure:str, relationship:list[str]):
        self.__head_comment["structure_info"]["related_structures"].append({related_structure: relationship})

    def add_source(self, short_name:str, info_filepath:str, consulted:bool) -> None:
        self.__head_comment["sources"].append({short_name: {
            "info_file": info_filepath,
            "consulted_for_file": consulted
        }})

    def overwrite_sources(self, _sources:dict) -> None:
        self.__head_comment["sources"] = _sources

    def get_head_comment(self) -> None:
        return self.__head_comment
    
    # =============================================
    #       Setting parameter info
    # =============================================

    def add_param_from_dict(self, _info:dict) -> None:
        self.__exposed_design_parameter_list.append(_info)
        if "passthrough_parameter" in _info:
            del _info["passthrough_parameter"]
        self.__head_comment["generator_settings"].append(_info)  # add to the header information as well

    def __add_parameter(self, _name:str, _type:type, _default, _range:list, _options:list) -> None:
        param_info = {
            "name": _name,
            "type": _type,
            "default": _default
        }
        if len(_range) > 0:
            param_info["range"] = _range
        if len(_options) > 0:
            param_info["options"] = _options

        self.__exposed_design_parameter_list(param_info)
        if "passthrough_parameter" in param_info:
            del param_info["passthrough_parameter"]
        self.__head_comment["generator_settings"].append(param_info)  # add to the header information as well

    def add_float_parameter(self, _name:str, _default:float, _range:list[float]=[]) -> None:
        self.__add_parameter(_name, float, _default, _range, [])

    def add_int_parameter(self, _name:str, _default:int, _range:list[int]=[]) -> None:
        self.__add_parameter(_name, int, _default, _range, [])

    def add_bool_parameter(self, _name:str, _default:bool) -> None:
        self.__add_parameter(_name, bool, _default, [True, False])

    def get_param_signature_string(self) -> str:
        param_sig = ""
        for pid in range(len(self.__exposed_design_parameter_list)):
            p = self.__exposed_design_parameter_list[pid]
            param_sig += f'{p["name"]}:{p["type"]}={p["default"]}'
            if pid < len(self.__exposed_design_parameter_list)-1:
                param_sig += ", "
        return param_sig