from metagen.training import *
from argparse import ArgumentParser
import json

def main():
    parser = ArgumentParser(description="Run Bedrock training.")
    parser.add_argument('configpath', type=str, help='Path to the configuration file.')
    args = parser.parse_args()

    with open(args.configpath, 'r') as f:
        config = json.load(f)
    
    if 'jobs' in config:
        enqueue_bedrock_training(config['jobs'])
    else:
        run_and_monitor_bedrock_training(**config)

if __name__ == "__main__":
    main()