"""
Analyze failure cases from data processing.
"""

from metagen.analysis import *
from metagen.util import *
import os
from tqdm.contrib.concurrent import process_map

def load_failures(data_root,level=None):
    """
    Load failure cases from data processing.
    """

    failure_root = os.path.join(data_root, 'workspace/failed')
    if level is not None:
        failure_root = os.path.join(failure_root, str(level))
    
    all_result_locations = list_all_filtered(data_root, ['**/processing_info.json'])
    results = []
    for uri in tqdm(all_result_locations):
        with open_file(uri) as f:
            results.append(json.load(f))
    return results

def summarize_failure_results(results):
    """
    Summarize failure results.
    """
    summarization = pd.DataFrame.from_records([process_failure_record(r) for r in results])
    return summarization

def process_failure_record(rec):
    return {
        'src': rec['src'],
        'reason': rec['reason'],
        'oom': rec['gen_and_sim_likely_oom'] if 'gen_and_sim_likely_oom' in rec else False,
        'gen_reason': rec['gen_and_sim_reason'] if 'gen_and_sim_reason' in rec else None,
        'time' : rec['gen_and_sim_time_seconds'] if 'gen_and_sim_time_seconds' in rec else None,
        'valid' : rec['valid'] if 'valid' in rec else None,
    }