"""
Enumeration worker. Since enumeration programs sometimes call external modules, we
cannot run them inside the process and must run them independently
"""

from metagen.synthesis.common import SynthesisConfig
import tempfile
import os
import subprocess
import shutil

def run_enumerate_all():
    from argparse import ArgumentParser
    parser = ArgumentParser()
    parser.add_argument('--basedir', '-b', type=str, help='Path to dataset base directory.')
    parser.add_argument('--searchdir', '-s', type=str, help='Path within dataset base directory to search for parametric programs.')
    parser.add_argument('--outdir', '-o', type=str, help='Path within dataset base directory to write sampled programs.')
    args = parser.parse_args()
    enumerate_all(args)


def enumerate_all(args):
    from metagen.util import list_all_filtered
    searchdir = os.path.join(args.basedir, args.searchdir.lstrip('/'))
    outdir = os.path.join(args.basedir, args.outdir.lstrip('/'))
    programs = list_all_filtered(searchdir, ['**/program.py'])

    # We need
    # - the name of each generator (e.g. relative path to it from searchdir)
    stems = [p[len(searchdir):-len('/program.py')].lstrip('/') for p in programs]
    
    for program, stem in zip(programs, stems):
        with tempfile.TemporaryDirectory() as tmp:
            subprocess.run(['python', program, tmp])
            generated = [f for f in os.listdir(tmp) if f.endswith('.py')]
            for g in generated:
                name = '.'.join(g.split('.')[:-1])
                directory = os.path.join(outdir, stem, name)
                path = os.path.join(directory, 'program.py')
                os.makedirs(directory, exist_ok=True)
                shutil.copy2(os.path.join(tmp,g), path)
                