"""
Synthesis pipeline worker that runs MetaGen programs from the process queue, validates the output,
and sends valid results to the output queue.
"""
import shutil
import os
from metagen.util import list_all_filtered
from metagen.processing import process_material
from metagen.synthesis.common import SynthesisConfig

def run_worker():
    num_processed_in_iteration = -1
    while num_processed_in_iteration != 0:
        num_processed_in_iteration = 0
        processing_queue = get_processing_queue()
        for program in processing_queue:
            if is_locked(program):
                continue
            else:
                get_lock(program)
                num_processed_in_iteration += 1
            process(program)

def is_locked(program):
    return os.path.exists(program / 'lockfile')

def get_lock(program):
    with open(program / 'lockfile', 'w') as f:
        f.write('')

def remove_lock(program):
    os.remove(program / 'lockfile')

def get_processing_queue(config):
    processing_path = config.datapath / 'to_process'
    return [os.path.dirname(x) for x in list_all_filtered(processing_path, ['**/code.py'])]

def process(program,  config: SynthesisConfig):
    program = os.path.abspath(program)
    datapath = os.path.abspath(config.datapath)
    prog_suffix = program[len(datapath)+1:]
    success_dir = os.path.join(datapath, 'to_integrate', prog_suffix)
    fail_dir = os.path.join(datapath, 'failed', prog_suffix)
    final_dir = os.path.join(datapath, 'materials', prog_suffix) # TODO - How to deal with ordering (absolute numbering?)
    log_data = {}
    process_material(program, success_dir, fail_dir, config.resolution, log_data, config.memlimit, config.timeout, final_dir, [0.5, 0.5, 0.5])
    # Clean up processing directory when done
    shutil.rmtree(program, ignore_errors=True)
