from setuptools import setup

setup(
    name='metagen',
    version='0.0.1',
    author='MetaGen Authors',
    author_email='metagendatabase@gmail.com',
    description='Automatic generation of metamaterials.',
    packages=['metagen', 'metagen.dsl', 'metagen.infrastructure', 'metagen.synthesis'],
    entry_points={
        'console_scripts': [
            'render = metagen:render',
            'process_material = metagen:run_process_material',
            'batch_process_materials = metagen:run_batch_process_programs',
            'generate_variations = metagen:generate_variations',
            'upload_seeds = metagen:run_upload_seeds',
            'run_metagen_server = metagen:run_server',
            'run_metagen_program = metagen:run_metagen_program',
            'sample_parametric_programs = mategen:run_sample_parametric_programs',
            'enumerate_all = metagen:run_enumerate_all',
            'bedrock_training = metagen:run_bedrock_training',
            'bedrock_inference = metagen:run_bedrock_inference'
        ]
    }
)
