#!/usr/bin/env bash
METHOD=holdout

MODELS=("gpt-4.1" "gpt-5" "o4-mini" "gpt-5-med" "deepseek" "o3" "llama" "gpt-5-high")

for MODEL in "${MODELS[@]}"; do
  echo "Running grid search for test model: $MODEL"
  python ./CancerGUIDE/main_analysis/roc_generation.py --mode grid_search \
    --models gpt-4.1 gpt-5 o4-mini gpt-5-med deepseek o3 llama gpt-5-high\
    --train-sizes 0.25 \
    --feature-sets all internal base base_aggregated aggregated_only\
    --methods $METHOD \
    --testmodel $MODEL \
    --outdir ./CancerGUIDE/results/json_results/ \
    --heatmap_results ./CancerGUIDE/results/heatmap_results.json
done