# CancerGUIDE: Cancer Guideline Understanding via Internal Disagreement Estimation

This project aims to generate **treatment predictions and clinical trajectories** for patients with **non-small cell lung cancer (NSCLC)** using large language models (LLMs) applied to real-world clinical notes.

## 📁 Project Structure

### 1. `benchmark_generation`

- Contains source code for generating consistency bench + synthetic benchmarks

### 2. `error_analysis`

- Contains source code for generating analysis regarding zero-shot model failure mode predictions
 
### 3. `main_analysis`

- Contains source code for generating model performance on cross-model consistency benchmark, general evaluation scripts, and ROC curve generation files.

### 4. `plot_generation`
- Includes scripts for heatmap, bar chart, ROC curves, and confusion matrix analyses from main paper.

### 5. `bash`
- Contains ordered bash scripts for executing code to validate paper performance. Ordered by analyses present in paper.
