#!/usr/bin/env bash
job_id=$1
config_file=$2

project_home='ICLR2022'

export HOME=${HOME}
echo 'HOME is '${HOME}
cd ${HOME}'/PycharmProjects/'${project_home} || exit

trainer_class=gvb
validator_class=gvb
scripts_path=$HOME'/PycharmProjects/'${project_home}'/experiments/scripts/get_visible_card_num.py'
GPUS=$(python ${scripts_path})
PORT=16614

python_file=./train.py
# TODO: 去掉 CUDA_LAUNCH_BLOCKING=1
python -m torch.distributed.launch --nproc_per_node=$GPUS --master_port=$PORT \
  ${python_file} --task_type cls --job_id ${job_id} --config ${config_file} \
  --trainer ${trainer_class} --validator ${validator_class}
