import numpy as np
import os
import pytorch_lightning as pl
import random
import sys
import torch

import experiment
import parameters_util

# set random seeds
os.environ['PYTHONHASHSEED'] = '0'
np.random.seed(0)
random.seed(0)
torch.manual_seed(0)
pl.seed_everything(0)

if __name__ == '__main__':
    device = torch.device('cpu')
    print('device:', device)

    args = parameters_util.parse_args()
    experiment.cross_validation(args)
