import numpy as np
import torch


def try_gpu(e):
    return e

def convert_f2F(f_pred):
    cum_pred = torch.cumsum(f_pred, dim=1)
    F_pred = torch.cat([torch.zeros(f_pred.shape[0],1), cum_pred], 1)
    return F_pred

def time2quantiles_dr(F_pred, F_boundaries, z):
    idx = torch.searchsorted(F_boundaries, z, right=True).view(-1)
    b_lb = F_boundaries[idx-1]
    b_ub = F_boundaries[idx]
    ratio = (z - b_lb)/(b_ub - b_lb)
    F_lb = torch.gather(F_pred, 1, idx.view(-1,1)-1)
    F_ub = torch.gather(F_pred, 1, idx.view(-1,1))
    quantiles = (1.0 - ratio) * F_lb.view(-1) + ratio * F_ub.view(-1)
    return quantiles

def time2quantiles_qr(time_seq, taus, z):
    idx = torch.searchsorted(time_seq, z, right=True)
    lb = torch.gather(time_seq, 1, idx-1)
    ub = torch.gather(time_seq, 1, idx)
    ratio = (z - lb)/(ub - lb)
    quantiles = (1.0 - ratio) * taus[idx-1] + ratio * taus[idx]
    return quantiles
