import matplotlib.pyplot as plt
import numpy as np
import seaborn as sns
import sys
import umap


def show_umap(dataset, filename):
    print('ratio of uncensored data', np.average(dataset.original_y[:,1]))
    mapper = umap.UMAP(random_state=0)
    embedding = mapper.fit_transform(dataset.original_x)
    y = dataset.original_y[:,0] * dataset.original_y[:,1]
    plt.rcParams['image.cmap'] = 'Reds'
    plt.scatter(embedding[:,0],embedding[:,1],c=y,alpha=0.99,s=8)
    plt.colorbar()
    #plt.show()
    print('Write '+filename)
    plt.savefig(filename)
    sys.exit()

def show_pairplot(df, category, filename):
    print('show_pairplot')
    figure = sns.pairplot(df, hue = category, plot_kws = {'alpha': 0.5})
    #plt.show()
    print('Wrtiting '+filename)
    figure.savefig(filename)
    sys.exit()
