import matplotlib.cm as cm
import matplotlib.patches as patches
import matplotlib.pyplot as plt
import numpy as np


def show_histogram(y_dist, boundaries, label, color='r'):
    n_bin = len(y_dist)
    w = boundaries[1] - boundaries[0]
    plt.bar(boundaries[:n_bin], y_dist, color=color, width=w, align='edge', label=label)
    plt.legend()
    plt.show()

def show_quantiles(y_dist, y_train, quantiles):
    q = np.array(quantiles)
    pred = np.array(y_dist[:len(q)])
    p1 = plt.plot(q, pred, linewidth=1, marker="D", markersize=4)
    p2 = plt.plot(q, y_train, linewidth=1, marker="o", markersize=4)
    plt.legend((p1[0], p2[0]), ("Prediction", "Test"), loc=2)
    plt.show()

def output_png_quantile_regression(dataset, predictions, quantiles, filename):
    print('output_png_quantile_regression')
    print(filename)

    fig = plt.figure(figsize=(7, 4))
    ax = fig.add_subplot(111)
    ax.set_position([0.2,0.15,0.55,0.78])

    #fig.suptitle('Baseline', fontsize=10)
    fig.suptitle('DC-LSTM', fontsize=10)
    plt.xlabel('x', fontsize=10)
    h = plt.ylabel('y', fontsize=10)
    h.set_rotation(0)

    # plot original data
    ax.scatter(dataset.original_x_train[:,0], dataset.original_y_train)

    # plot prediction
    num_col = predictions.shape[1]
    print(dataset.original_x_test[:,0].shape)
    for i in range(num_col):
        height = predictions[:,i]
        label = '{:.1f}-quantile'.format(quantiles[i])
        temp = np.stack([dataset.original_x_test[:,0], height], 1)
        temp = temp[temp[:,0].argsort(), :]
        ax.plot(temp[:,0], temp[:,1], color=cm.hsv(i/num_col), label=label)
    ax.legend(bbox_to_anchor=(1.05, 1), loc='upper left', borderaxespad=0, fontsize=10)

    plt.show()
