## Patch-Prompt Aligned Bayesian Prompt Learning for Vision-Language Models

This folder contains the implementation of our ICLR2024 submission "Patch-Prompt Aligned Bayesian Prompt Learning for Vision-Language Models".

This code is built on top of [CoOp](https://github.com/KaiyangZhou/CoOp).

## Build Environment
Following CoOp, it is needed to install the `dassl` environment. You can follow the scripts [Dassl](https://github.com/KaiyangZhou/Dassl.pytorch#installation) to install `dassl` as well as PyTorch. Then, you can install other package by running `pip install -r requirements.txt` (this should be done when `dassl` is activated).


## Install Dataset
Please follow the instructions [DATASETS.md](https://github.com/KaiyangZhou/CoOp/blob/main/DATASETS.md) to construct the datasets.


## Run Scripts

The running scripts are in `scripts/pbprompt`. Change the `data_path` in `scripts/pbprompt/train_fsl.sh`
Then, you can run the commands `bash scripts/pbprompt/train_fsl.sh DATASET`.

`DATASET` takes as input a dataset name, like `caltech101`. 

### Results

Same as CoOp, you can find the results from `output/` whose structure is

```
output
|–– fewshot/vit_b16/caltech101/
|   |–– PBPrompt
|   |   |–– shots_8/
|   |   |   |   |–– seed1/
|   |   |   |   |–– seed2/
|   |   |   |   |–– seed3/
|   |   |–– shots_16/
|   |   |   |   |–– seed1/
|   |   |   |   |–– seed2/
|   |   |   |   |–– seed3/
```

## Acknowledgements
This code is based on [CoOp](https://github.com/KaiyangZhou/CoOp). We thank the authors
 for releasing their code. If you use our model and code, please consider citing these papers as well.