import typing
import utils
from meteor_reasoner.utils.loader import load_dataset, load_program
from meteor_reasoner.utils import parser as parser

def convert_to_nl(instance: dict) -> dict:
    dataset = load_dataset(instance['data'])
    new_instance = {}
    new_instance['data'] = []
    for predicate in dataset:
        for entity, intervals in dataset[predicate].items():
            for interval in intervals:
                new_instance['data'].append(utils.dump_single_data_nl((predicate,
                                        entity, interval)))

    new_instance['query'] = utils.dump_single_data_nl(parser.parse_str_fact(instance['query']))
    program = load_program(instance['rule'])
    new_instance['rule'] = []
    for rule in program:
        msg = "%s holds in each time such that "%(str(rule.head))
        for literal in rule.body:
            assert(len(literal.operators) == 1)
            if literal.operators[0].name == "Diamondminus":
                msg += "%s did hold sometime between %0.3f and %0.3f hours before, and"%(str(literal.atom), literal.operators[0].interval.left_value, literal.operators[0].interval.right_value)
            elif literal.operators[0].name == "Diamondplus":
                msg += "%s will hold sometime between %0.3f and %0.3f hours in the future, and"%(str(literal.atom), literal.operators[0].interval.left_value, literal.operators[0].interval.right_value)
            elif literal.operators[0].name == "Boxminus":
                msg += "%s did hold continuously for %0.3f and %0.3f hours before, and"%(str(literal.atom), literal.operators[0].interval.left_value, literal.operators[0].interval.right_value)
            elif literal.operators[0].name == "Boxplus":
                msg += "%s will hold continuously for %0.3f and %0.3f hours in the future, and"%(str(literal.atom), literal.operators[0].interval.left_value, literal.operators[0].interval.right_value)
            else:
                raise("not implemented")
        new_instance['rule'].append(msg[:-5])
    new_instance['valid'] = instance['valid']
    return new_instance