import pandas as pd

pp_names = {
    "params/bootstrap_samples": "bstrap",
}


def preprocess_results(results: pd.DataFrame) -> pd.DataFrame:
    """Preprocess the results by appending parameters to the method."""
    # copy column "params/method" in "Method"
    results["Method"] = results["params/method"]

    # iterate over columns starting with "params/"
    params = results.filter(regex="params/").columns
    # ignore params/run
    params = [param for param in params if param != "params/run"]

    for param in params:
        # check if unique when "params/method" = "Abs-Fit"
        sub_frame = results[results["params/method"] == "Abs-Fit"]
        unique = sub_frame[param].unique()
        if len(unique) > 1:
            print("log: found", param, "with multiple values", unique)

            # pretty name
            try:
                param_name = pp_names[param]
            except KeyError:
                param_name = param.split("/")[-1]

            # Create string param_name=value and append to Method
            index = results["params/method"] == "Abs-Fit"
            results.loc[index, "Method"] = (
                results[index]["Method"]
                + " "
                + param_name
                + "="
                + results[index][param].astype(str)
            )

    return results
