using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.SceneManagement;
using UnityEngine.Tilemaps;
using UnityEngine.UI;

public class PlayerBehaviourML : MonoBehaviour
{
    public float speed; //speed of character
    public float jumpForce; //how highhhh
    public float moveInput;

    private Rigidbody2D rb;
    private bool facingRight = true;
    [SerializeField]private Vector2 spawnPoint; // set at construct

    private bool isGrounded;
    public Transform groundCheck;
    public float checkRadius;
    public LayerMask whatIsGround;
    //private TilemapCollider2D tilemapCollider;
    public Tilemap tilemap;
    public Animator anim;

    private List<ContactPoint2D> contactPoints;
    private SpriteRenderer spriteRenderer;
    private int extraJumps;
    public int extraJumpsValue;
    public float deadFlashingTimer;

    public int attempts;
    public Text attemptTxt;

    //public string levelToLoad;

    public int currLevel;

    void Start()
    {
        deadFlashingTimer = 0f;
        extraJumps = extraJumpsValue;
        //tilemapCollider = tilemap.GetComponent<TilemapCollider2D>();
        rb = GetComponent<Rigidbody2D>();
        //spawnPoint = rb.position;
        contactPoints = new List<ContactPoint2D>();
        spriteRenderer = GetComponent<SpriteRenderer>();
        attempts = 10;
        attemptTxt.text = attempts.ToString();
        //PlayerPrefs.SetString("NextLevel", levelToLoad);
    }

    void FixedUpdate() //to manage physics aspects
    {
        if (deadFlashingTimer > 0f)
        {
            spriteRenderer.enabled = (Mathf.RoundToInt(deadFlashingTimer * 1000f) % 100) > 50; // blink 10 times per second
            deadFlashingTimer -= Time.deltaTime;
            if (deadFlashingTimer <= 0f)
            {
                spriteRenderer.enabled = true;
            }
        }
        isGrounded = Physics2D.OverlapCircle(groundCheck.position, checkRadius, whatIsGround);
        Vector2 hitPosition = Vector2.zero;
        // walk collisions and see if the ground is ever in there
        contactPoints.Clear();
        //tilemapCollider.GetContacts(contactPoints);
        foreach (ContactPoint2D contactPoint in contactPoints)
        {
            hitPosition.x = contactPoint.point.x + (0.1f * contactPoint.normal.x);
            hitPosition.y = contactPoint.point.y + (0.1f * contactPoint.normal.y);
            Vector3Int cellPosition = tilemap.WorldToCell(hitPosition);
            //debug.transform.position = new Vector3(hitPosition.x, hitPosition.y, 0);  //tilemap.CellToWorld(cellPosition);
            TileBase t = tilemap.GetTile(cellPosition);
            if (t != null)
            {
                if (tilemap.GetSprite(cellPosition).name.IndexOf("spike") > -1)
                {
                    Die();
                    break;
                }
            }
        }

        moveInput = Input.GetAxis("Horizontal"); //unity built in fx; moveinput = 1 for right, moveinput = -1 for left
        rb.velocity = new Vector2(moveInput * speed, rb.velocity.y);
        anim.SetFloat("Speed", Mathf.Abs(moveInput));

        if (facingRight == false && moveInput > 0)
        {
            Flip();
        }
        else if (facingRight == true && moveInput < 0)
        {
            Flip();
        }

        if (moveInput > 0 && Input.GetKeyDown(KeyCode.RightArrow))
        {
            anim.Play("Run");
        }
        else if (moveInput < 0 && Input.GetKeyDown(KeyCode.LeftArrow))
        {
            anim.Play("Run");
        }
    }

    void Update()
    {
        if (isGrounded == true)
        {
            extraJumps = extraJumpsValue;
        }

        if (Input.GetKeyDown(KeyCode.Space) && extraJumps > 0)
        {
            rb.velocity = Vector2.up * jumpForce;
            anim.Play("Jump");
            extraJumps--;
        }
        else if (Input.GetKeyDown(KeyCode.Space) && extraJumps == 0 && isGrounded == true)
        {
            rb.velocity = Vector2.up * jumpForce;
            anim.Play("Jump");
        }
    }

    void Flip()
    {
        facingRight = !facingRight;
        Vector3 Scaler = transform.localScale;
        Scaler.x *= -1;
        transform.localScale = Scaler;
    }

    void Die()
    {
        rb.position = spawnPoint;
        deadFlashingTimer = 0.5f;
        attempts--;
        attemptTxt.text = attempts.ToString();
        if (attempts == 0)
        {
            if (currLevel != 3)
            {
                SceneManager.LoadScene("LevelCompleteFail");
            }
            else
            {
                SceneManager.LoadScene("End");
            }
        }
    }

    private void OnTriggerEnter2D(Collider2D collision)
    {
        Debug.Log(collision);
        if (collision.tag == "Portal" && currLevel != 3)
        {
            //SceneManager.LoadScene("LevelCompleteSuccess");
            SceneManager.LoadScene("Level1 - High Difficulty");
            Debug.Log("Going to next level");
        }
        if(collision.tag == "Spike")
        {
            Die();
        }
        else
        {
            SceneManager.LoadScene("End");
        }
    }
}
