using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.Tilemaps;

public class MLLayoutGen : LevelGenerator
{
    RLAgent agent;
    WriteLogFiles wLF;
    public int bernoulliParam;
    [HideInInspector] public int totalLength = 45;

    int currentStepLevel, lastStepHeight, concurrentspike = 0;

    [HideInInspector] public Tile noTile;
    public Tile spikeTile, landTile, endTile;

    public Tilemap envTilemap, triggerTilemap;

    public Vector3Int[] startTiles;

    public GameObject[] levelTools; //0 tile , 1 spike, 2 portal
    public Vector2 endPosition;

    public string groundDecisionLog, spikeDecisionLog;

    string LevelLayoutPos;
    int levelNum = 0;
    // parent to store the level
    [SerializeField]
    Transform level;

    // Start is called before the first frame update
    void Start()
    {
        wLF = FindObjectOfType<WriteLogFiles>();
        agent = FindObjectOfType<RLAgent>();
        StartingTiles();
        //GenerateTile();
        //EndingTiles();
    }

    // Update is called once per frame
    void Update()
    {
        if (Input.GetKeyDown(KeyCode.O))
        {
            GenerateLevel();
            //PlayerController.RespawnWithNewLevel();
            CreateLevelData();
            agent.attempts = 0;
        }
    }

    public override Vector2 goalPosition
    {
        get
        {
            return endPosition;
        }
    }

    void StartingTiles()
    {
        // set at 0,0
        Instantiate(levelTools[0], level);
    }

    public override void recordResponse(float response)
    {

    }

    public override void GenerateLevel()
    {
        // shld use object pool, but for now jus create and destroy
        RemoveAllTiles();
        LevelLayoutPos = "";
        int prevHeight = 0;
        int tempSpike = 0;
        currentStepLevel = 0;
        lastStepHeight = 0;
        bernoulliParam = Random.Range(0, 100);
        for (int i = 1; i <= totalLength; ++i)
        {
            // tempStepHeight is used to determine where the til is at on the y axis
            int tempStepHeight = Random.Range(-2, 2);
            if (tempStepHeight - lastStepHeight > 2)
            {
                tempStepHeight = 0;
            }
            groundDecisionLog += tempStepHeight + ",";

            int spikeRoll = Random.Range(0,100);
            if (spikeRoll > bernoulliParam)
            {
                tempSpike = 1;
            }
            else
            {
                tempSpike = 0;
            }
            spikeDecisionLog += tempSpike + ",";
            currentStepLevel += tempStepHeight;
            Vector3Int tempPosition = new Vector3Int(i, currentStepLevel, 0);

            //envTilemap.SetTile(temp, landTile);

            if (i == totalLength)
            {
                // add portal on top of the end tile
                Vector3Int temPosG = new Vector3Int(i, tempPosition.y + 1, 0);

                GameObject tempGO = Instantiate(levelTools[2], temPosG, Quaternion.identity, level);
                endPosition = new Vector2(tempGO.gameObject.transform.position.x - 1, tempGO.gameObject.transform.position.y);
                LevelLayoutPos += "Goal " + temPosG.ToString() + "\n";
                for (int a = 1; a < 4; a++)
                {
                    Vector2 temPos = new Vector2(endPosition.x + 1, endPosition.y - a);
                    Instantiate(levelTools[0], temPos, Quaternion.identity, level);
                    LevelLayoutPos += "G " + temPos.ToString() + "\n";
                }
                StartCoroutine(DataHandler.PostLevelPos(levelNum + " Data set for " + DataHandler.s_PlayerID + " " + LevelLayoutPos));
                levelNum++;
                return;
                //envTilemap.SetTile(new Vector3Int(i + 1, currentStepLevel, 0), landTile);
                //triggerTilemap.SetTile(new Vector3Int(i + 1, currentStepLevel + 1, 0), endTile);
            }
            // if got spike
            if (tempSpike == 1)
            {
                ++concurrentspike;

                // if consecutive spikes are more than 2, just reset the counter
                if (concurrentspike >= 2)
                {
                    concurrentspike = 0;
                    Instantiate(levelTools[0], tempPosition, Quaternion.identity, level);
                    LevelLayoutPos += "G " + tempPosition.ToString() + "\n";
                }
                else
                {
                    Vector3Int temPosG = new Vector3Int(i, tempPosition.y - 1, 0);
                    Vector3Int temPosS = new Vector3Int(i, tempPosition.y, 0);

                    Instantiate(levelTools[0], temPosG, Quaternion.identity, level);
                    Instantiate(levelTools[1], temPosS, Quaternion.identity, level);

                    LevelLayoutPos += "S " + temPosS.ToString() + " G " + temPosG.ToString() + "\n";
                    // tempStepHeight needs to minus 1 as current height is for spikes, minus 1 is for the land
                    tempStepHeight -= 1;

                    // set the land tile 1 tile below
                    //envTilemap.SetTile(new Vector3Int(i, temp.y - 1, 0), landTile);
                    // set the spike tile on the chosen tile
                    //envTilemap.SetTile(new Vector3Int(i, temp.y, 0), spikeTile);
                }
            }
            // generate ground
            else
            {
                Instantiate(levelTools[0], tempPosition, Quaternion.identity, level);
                LevelLayoutPos += "G " + tempPosition.ToString() + "\n";
            }

            lastStepHeight = tempStepHeight;
            currentStepLevel = 0;

            // not first element
            if (i > 0)
            {
                // current chosen is taller than previous
                if (tempStepHeight >= prevHeight)
                {
                    // loop and add the bottom tiles for the chosen x position all the way down to the prev tile height
                    for (int j = tempStepHeight - 1; j > prevHeight; --j)
                    {
                        Vector3Int temPosG = new Vector3Int(i, j, 0);
                        Instantiate(levelTools[0], temPosG, Quaternion.identity, level);
                        LevelLayoutPos += "G " + temPosG.ToString() + "\n";
                        //envTilemap.SetTile(new Vector3Int(i, j, 0), landTile);
                    }
                }
                // current chosen is lower than previous
                else
                {
                    // loop and add the tiles on the previous x position all the way up to the prev tile height
                    for (int j = tempStepHeight + 1; j < prevHeight; ++j)
                    {
                        Vector3Int temPosG = new Vector3Int(i - 1, j, 0);
                        Instantiate(levelTools[0], temPosG, Quaternion.identity, level);
                        LevelLayoutPos += "G " + temPosG.ToString() + "\n";
                        //envTilemap.SetTile(new Vector3Int(i - 1, j, 0), landTile);
                    }
                }
            }

            //if (i == totalLength)
            //{
            //    // add portal on top of the end tile
            //
            //    GameObject tempGO = Instantiate(levelTools[2], new Vector3Int(i, tempPosition.y + 1, 0), Quaternion.identity, level);
            //    endPosition = new Vector2(tempGO.gameObject.transform.position.x - 1, tempGO.gameObject.transform.position.y);
            //    print(endPosition);
            //    //envTilemap.SetTile(new Vector3Int(i + 1, currentStepLevel, 0), landTile);
            //    //triggerTilemap.SetTile(new Vector3Int(i + 1, currentStepLevel + 1, 0), endTile);
            //}
            prevHeight = tempStepHeight;
        }
    }

    public override void CreateLevelData()
    {
        wLF.CreateTextFile("GroundHeight",groundDecisionLog);
        wLF.CreateTextFile("SpikeDecision", spikeDecisionLog);
        string reward = agent.GetCumulativeReward().ToString();
        wLF.CreateTextFile("AgentReward", reward);
        wLF.CreateTextFile("Bernoulli", bernoulliParam.ToString());
        groundDecisionLog = "";
        spikeDecisionLog = "";
    }
    public override void RemoveAllTiles()
    {
        for (int i = level.childCount - 1; i > 0; --i)
        {
            Destroy(level.GetChild(i).gameObject);
        }
    }
    //public void GenerateLevel()
    //{
    //    envTilemap.ClearAllTiles();
    //    StartingTiles();
    //    //GenerateTile();
    //    EndingTiles();
    //}

    //void StartingTiles()
    //{
    //    for (int a = 0; a < startTiles.Length; a++)
    //    {
    //        envTilemap.SetTile(startTiles[a], landTile);
    //    }
    //    EndlessPit();
    //}

    //void EndingTiles()
    //{
    //    for (int a = -3; a < 6; a++)
    //    {
    //        envTilemap.SetTile(new Vector3Int(totalLength + 1, a, 0), landTile);
    //    }
    //}

    //void EndlessPit()
    //{
    //    for (int a = -5; a <= totalLength + 7; a++)
    //    {
    //        //envTilemap.SetTile(new Vector3Int(a, -14, 0), spikeTile);
    //    }
    //}
    //public void GenerateTile()
    //{
    //    //for(int i = 0; i<totalLength; i++)
    //    //{
    //    //    Vector3Int temp = new Vector3Int(i, 0, 0);
    //    //    envTilemap.SetTile(temp, landTile);
    //    //}

    //    int prevHeight = 0;

    //    for (int i = 0; i < totalLength; i++)
    //    {
    //        int tempStepHeight = Random.Range(-2, 3);
    //        if (tempStepHeight - lastStepHeight > 2)
    //        {
    //            tempStepHeight = 0;
    //        }
    //        int tempSpike = Random.Range(0, 2);
    //        currentStepLevel += tempStepHeight;
    //        Vector3Int temp = new Vector3Int(i, currentStepLevel, 0);
    //        envTilemap.SetTile(temp, landTile);
    //        lastStepHeight = tempStepHeight;
    //        currentStepLevel = 0;

    //        // if got spike
    //        if (tempSpike == 1)
    //        {
    //            ++concurrentspike;

    //            // if consecutive spikes are more than 3, just reset the counter
    //            if (concurrentspike > 3)
    //            {
    //                concurrentspike = 0;
    //            }
    //            else
    //            {
    //                // set the land tile 1 tile below
    //                envTilemap.SetTile(new Vector3Int(i, temp.y - 1, 0), landTile);
    //                // set the spike tile on the chosen tile
    //                envTilemap.SetTile(new Vector3Int(i, temp.y, 0), spikeTile);
    //            }
    //        }

    //        // not first element
    //        if (i > 0)
    //        {
    //            // current chosen is taller than previous
    //            if (tempStepHeight >= prevHeight)
    //            {
    //                // loop and add the bottom tiles for the chosen x position all the way down to the prev tile height
    //                for (int j = tempStepHeight; j > prevHeight; --j)
    //                {
    //                    envTilemap.SetTile(new Vector3Int(i, j, 0), landTile);
    //                }
    //            }
    //            // current chosen is lower than previous
    //            else
    //            {
    //                // loop and add the tiles on the previous x position all the way up to the prev tile height
    //                for (int j = tempStepHeight; j < prevHeight; ++j)
    //                {
    //                    envTilemap.SetTile(new Vector3Int(i - 1, j, 0), landTile);
    //                }
    //            }
    //        }

    //        if (i == totalLength - 1)
    //        {
    //            envTilemap.SetTile(new Vector3Int(i + 1, currentStepLevel, 0), landTile);
    //            triggerTilemap.SetTile(new Vector3Int(i + 1, currentStepLevel + 1, 0), endTile);
    //        }
    //        prevHeight = tempStepHeight;
    //    }
    //}
}
