using System.Collections;
using System.Collections.Generic;
using Unity.Barracuda;
using UnityEngine;

public class PERMGenerator : MonoBehaviour
{
    public NNModel modelAsset;
    private Model runtimeModel;
    private IWorker worker;
    private float responseMu;
    private float responseScale;
    RLAgent agent;
    // Start is called before the first frame update
    void Awake()
    {
        runtimeModel = ModelLoader.Load(modelAsset);
        var additionalOutputs = new string[] {"/Add_6_output_0"};
        worker = WorkerFactory.CreateWorker(WorkerFactory.Type.CSharp, runtimeModel, additionalOutputs, false);
        agent = FindObjectOfType<RLAgent>();

        responseMu = 60.44040981f;
        responseScale = 138.23256807f;
    }

    private float[][] preprocessResponse(float[][] response)
    {
        var processedResponse = new float[3][];
        float new_value;
        for (int row = 0; row < response.GetLength(0); row++)
        {
            new_value = (response[row][0] - responseMu) / responseScale;
            processedResponse[row] = new float[1]{new_value};
        }

        return processedResponse;
    }

    public Tensor Generate(float[][] envParams, float[][] response)
    {
        var processedResponse = preprocessResponse(response);
        Tensor inputParams = new Tensor(3, 5, envParams);
        Tensor inputResponse = new Tensor(3, 1, processedResponse);

        var inputs = new Dictionary<string, Tensor>();
        inputs["params"] = inputParams;
        inputs["response"] = inputResponse;
        worker.Execute(inputs);
        Tensor ability = worker.CopyOutput("/Add_6_output_0");
        Tensor output = worker.CopyOutput("params_pred");

        agent.statsRecorder.Add("Difficulty", ability[0]);
        inputParams.Dispose();
        inputResponse.Dispose();
        ability.Dispose();
        return output;
    }

    public void OnDestroy()
    {
        worker.Dispose();
    }
}
