# Generative Modeling with Bayesian Sample Inference

## Installation

If you want to run our code, start by setting up the python environment.
We use [pixi](https://pixi.sh/) to easily set up reproducible environments based on conda packages.
Install it with `curl -fsSL https://pixi.sh/install.sh | bash` and then run

```sh
# Install and activate the environment
pixi shell
```

## Training

Start a training by running `train.py` with the your settings, for example
```sh
./train.py data=cifar10
```

We use [hydra](https://hydra.cc/) for configuration, so you can overwrite all settings from the command line, e.g. the dataset with `data=cifar10` as above.
Explore all options in the [`config`](./config) directory, e.g. with `./train.py trainer.devices=4 trainer.precision=bfloat16` you can train on 4 GPUs in 16-bit bfloat precision.

The `cifar10` data module will download the dataset for you, but for `imagenet32` and `imagenet64` you have to download the 32x32 and 64x64 versions yourself from [image-net.org](https://image-net.org/download-images.php) in `npz` format.
Unpack the archives into `data/imagenet32/data` and `data/imagenet64/data` respectively and then run `./train.py data=imagenet32` and `./train.py data=imagenet64` to preprocess them into hdf5 files.
