"""
This is a helper file for the dataloader module
"""

import torch

def config_consistency_check(config):
    """
    This functions raises ValueErrors if config is inconsitent in terms of support set requirements.
    It is currently not needed because we just use stratified split, but might help in future


    :param config: hydra config file
    """

    # Exactly one of stratifiedSplit, countSplit and ratioSplit should be True:
    binaryFlags = torch.tensor([config.supportSet.stratified.stratifiedSplit, config.supportSet.count.countSplit,
                   config.supportSet.ratio.ratioSplit])
    if binaryFlags[binaryFlags == True].__len__() != 1:
        raise ValueError('Config inconsistent:\n'
                         'Exactly one of stratifiedSplit, countSplit and ratioSplit should be True!')

    # If stratifiedSplit, countSplit or ratioSplit is False, all related flags should be set to -1
    if config.supportSet.stratified.stratifiedSplit == False:
        if config.supportSet.stratified.supportSetSize != -1:
            raise ValueError('Since stratifiedSplit is False, all related flags should be set to -1!')
    if config.supportSet.count.countSplit == False:
        if config.supportSet.count.numberInactives != -1 or config.supportSet.count.numberActives != -1:
            raise ValueError('Since countSplit is False, all related flags should be set to -1!')
    if config.supportSet.ratio.ratioSplit == False:
        if config.supportSet.ratio.ratioInactives != -1 or config.supportSet.ratio.ratioActives != -1:
            raise ValueError('Since ratioSplit is False, all related flags should be set to -1!')

