from transformers import AutoModel, AutoTokenizer
import os
import pathlib
SYS_PATH = pathlib.Path(os.path.dirname(os.path.realpath(__file__)))

class CREATE_SBERT_MODEL:
    def __init__(self):
        self.path = SYS_PATH / 'paraphrase-MiniLM-L6-v2'
        self.creat_model = False
        self.creat_tokenizer = False

    def get_sbert_model(self):
        if not self.creat_model:
            self.model = AutoModel.from_pretrained(self.path)
            self.creat_model = True
        return self.model

    def get_sbert_tokenizer(self):
        if not self.creat_tokenizer:
            self.tokenizer = AutoTokenizer.from_pretrained(self.path, use_fast=True)
            self.creat_tokenizer = True
        return self.tokenizer
