class BestGoal:
    def __init__(self):
        self.achievements_sequence = [
            'collect_wood',
            'collect_sapling',
            'place_table',
            'make_wood_pickaxe',
            'make_wood_sword',
            'collect_stone',
            'make_stone_pickaxe',
            'make_stone_sword',
            'collect_coal',
            'collect_iron',
            'place_furnace',
            'make_iron_pickaxe',
            'make_iron_sword',
            'collect_diamond',
            'place_stone',
            'place_plant',
            'collect_drink',
            'eat_plant',
            'eat_cow',
            'defeat_skeleton',
            'defeat_zombie',
            'wake_up'
        ]
        self.current_achievement_index = 0

    def parse_observation(self, text_obs):
        state = {
            'seen_entities': set(),
            'inventory': {},
            'status': {}
        }

        lines = text_obs.split('\n')
        seen_line = lines[0].strip()
        inv_line = lines[1].strip()
        status_line = lines[2].strip()

        if seen_line.startswith('You see: '):
            seen_part = seen_line[len('You see: '):].strip()
            state['seen_entities'] = set(entity.strip() for entity in seen_part.split(','))

        if inv_line.startswith('Inventory: '):
            inv_part = inv_line[len('Inventory: '):].strip()
            if inv_part:
                for item_str in inv_part.split(','):
                    if ':' in item_str:
                        name, count_str = item_str.split(':', 1)
                        name = name.strip().lower()
                        count = int(count_str.strip())
                        state['inventory'][name] = count

        if status_line.startswith('Status: '):
            status_part = status_line[len('Status: '):].strip()
            status_items = status_part.split(',')
            for item in status_items:
                if ':' in item:
                    key, value_str = item.split(':', 1)
                    key = key.strip()
                    value_str = value_str.strip()
                    if '%' in value_str:
                        value_str = value_str.replace('%', '').strip()
                    try:
                        value = int(value_str)
                        state['status'][key] = value
                    except ValueError:
                        pass

        return state

    def determine_goal(self, text_obs):
        state = self.parse_observation(text_obs)
        health = state['status'].get('health', 100)
        fullness = state['status'].get('Fullness', 100)
        hydration = state['status'].get('Hydration', 100)
        wakefulness = state['status'].get('Wakefulness', 100)
        seen_entities = state['seen_entities']
        inventory = state['inventory']

        if health < 30:
            if fullness == 0 and 'food' in inventory and inventory['food'] > 0:
                return 'eat'
            if hydration == 0 and 'drink' in inventory and inventory['drink'] > 0:
                return 'drink'
            return 'avoid_damage'

        if fullness < 30:
            if 'food' in inventory and inventory['food'] > 0:
                return 'eat'
            if 'cow' in seen_entities:
                return 'collect cow'
            if 'ripe plant' in seen_entities:
                return 'collect ripe_plant'
            return 'find_food'

        if hydration < 30:
            if 'drink' in inventory and inventory['drink'] > 0:
                return 'drink'
            if 'water' in seen_entities:
                return 'collect water'
            return 'find_water'

        if wakefulness < 30:
            if 'zombie' not in seen_entities and 'skeleton' not in seen_entities:
                return 'sleep'
            else:
                return 'clear_area_before_sleep'

        if 'zombie' in seen_entities or 'skeleton' in seen_entities:
            if inventory.get('iron sword', 0) > 0:
                return 'defeat mob with iron_sword'
            elif inventory.get('stone sword', 0) > 0:
                return 'defeat mob with stone_sword'
            elif inventory.get('wood sword', 0) > 0:
                return 'defeat mob with wood_sword'
            else:
                if 'crafting table' in seen_entities:
                    if inventory.get('wood', 0) >= 1:
                        return 'craft wood_sword'
                    else:
                        return 'collect_wood for sword'
                else:
                    return 'find_table_to_craft_sword'

        if fullness < 70 and 'cow' in seen_entities:
            return 'collect cow'
        if fullness < 70 and 'ripe plant' in seen_entities:
            return 'collect ripe_plant'

        while self.current_achievement_index < len(self.achievements_sequence):
            achievement = self.achievements_sequence[self.current_achievement_index]
            if self.is_achievement_done(achievement, state):
                self.current_achievement_index += 1
            else:
                goal = self.get_goal_for_achievement(achievement, state)
                if goal:
                    return goal
                self.current_achievement_index += 1

        return 'explore'

    def is_achievement_done(self, achievement, state):
        inventory = state['inventory']
        seen_entities = state['seen_entities']

        if achievement == 'collect_wood':
            return inventory.get('wood', 0) > 0
        elif achievement == 'collect_sapling':
            return inventory.get('sapling', 0) > 0
        elif achievement == 'place_table':
            return 'crafting table' in seen_entities
        elif achievement == 'make_wood_pickaxe':
            return inventory.get('wood pickaxe', 0) > 0
        elif achievement == 'make_wood_sword':
            return inventory.get('wood sword', 0) > 0
        elif achievement == 'collect_stone':
            return inventory.get('stone', 0) > 0
        elif achievement == 'make_stone_pickaxe':
            return inventory.get('stone pickaxe', 0) > 0
        elif achievement == 'make_stone_sword':
            return inventory.get('stone sword', 0) > 0
        elif achievement == 'collect_coal':
            return inventory.get('coal', 0) > 0
        elif achievement == 'collect_iron':
            return inventory.get('iron', 0) > 0
        elif achievement == 'place_furnace':
            return 'furnace' in seen_entities
        elif achievement == 'make_iron_pickaxe':
            return inventory.get('iron pickaxe', 0) > 0
        elif achievement == 'make_iron_sword':
            return inventory.get('iron sword', 0) > 0
        elif achievement == 'collect_diamond':
            return inventory.get('diamond', 0) > 0
        elif achievement == 'place_stone':
            return 'stone' in seen_entities
        elif achievement == 'place_plant':
            return 'plant' in seen_entities or 'ripe plant' in seen_entities
        elif achievement == 'collect_drink':
            return inventory.get('drink', 0) > 0
        elif achievement == 'eat_plant':
            return False
        elif achievement == 'eat_cow':
            return False
        elif achievement == 'defeat_skeleton':
            return False
        elif achievement == 'defeat_zombie':
            return False
        elif achievement == 'wake_up':
            return False
        return False

    def get_goal_for_achievement(self, achievement, state):
        inventory = state['inventory']
        seen_entities = state['seen_entities']

        if achievement == 'collect_wood':
            if 'tree' in seen_entities:
                return 'collect tree'
            else:
                return 'explore to find tree'
        elif achievement == 'collect_sapling':
            if 'grass' in seen_entities:
                return 'collect grass'
            else:
                return 'explore to find grass'
        elif achievement == 'place_table':
            if inventory.get('wood', 0) >= 2:
                return 'place table'
            else:
                return 'collect_wood for table'
        elif achievement == 'make_wood_pickaxe':
            if inventory.get('wood', 0) >= 1:
                if 'crafting table' in seen_entities:
                    return 'craft wood_pickaxe'
                else:
                    return 'go_to table'
            else:
                return 'collect_wood for pickaxe'
        elif achievement == 'make_wood_sword':
            if inventory.get('wood', 0) >= 1:
                if 'crafting table' in seen_entities:
                    return 'craft wood_sword'
                else:
                    return 'go_to table'
            else:
                return 'collect_wood for sword'
        elif achievement == 'collect_stone':
            if 'stone' in seen_entities:
                if inventory.get('wood pickaxe', 0) > 0 or inventory.get('stone pickaxe', 0) > 0 or inventory.get(
                        'iron pickaxe', 0) > 0:
                    return 'collect stone'
                else:
                    return 'get_pickaxe_for_stone'
            else:
                return 'explore to find stone'
        elif achievement == 'make_stone_pickaxe':
            if inventory.get('wood', 0) >= 1 and inventory.get('stone', 0) >= 1:
                if 'crafting table' in seen_entities:
                    return 'craft stone_pickaxe'
                else:
                    return 'go_to table'
            else:
                if inventory.get('wood', 0) < 1:
                    return 'collect_wood for stone_pickaxe'
                else:
                    return 'collect_stone for stone_pickaxe'
        elif achievement == 'make_stone_sword':
            if inventory.get('wood', 0) >= 1 and inventory.get('stone', 0) >= 1:
                if 'crafting table' in seen_entities:
                    return 'craft stone_sword'
                else:
                    return 'go_to table'
            else:
                if inventory.get('wood', 0) < 1:
                    return 'collect_wood for stone_sword'
                else:
                    return 'collect_stone for stone_sword'
        elif achievement == 'collect_coal':
            if 'coal' in seen_entities:
                if inventory.get('wood pickaxe', 0) > 0 or inventory.get('stone pickaxe', 0) > 0 or inventory.get(
                        'iron pickaxe', 0) > 0:
                    return 'collect coal'
                else:
                    return 'get_pickaxe_for_coal'
            else:
                return 'explore to find coal'
        elif achievement == 'collect_iron':
            if 'iron' in seen_entities:
                if inventory.get('stone pickaxe', 0) > 0 or inventory.get('iron pickaxe', 0) > 0:
                    return 'collect iron'
                else:
                    return 'get_stone_pickaxe_for_iron'
            else:
                return 'explore to find iron'
        elif achievement == 'place_furnace':
            if inventory.get('stone', 0) >= 1:
                return 'place furnace'
            else:
                return 'collect_stone for furnace'
        elif achievement == 'make_iron_pickaxe':
            if inventory.get('wood', 0) >= 1 and inventory.get('stone', 0) >= 1 and inventory.get('coal',
                                                                                                  0) >= 1 and inventory.get(
                'iron', 0) >= 1:
                if 'crafting table' in seen_entities and 'furnace' in seen_entities:
                    return 'craft iron_pickaxe'
                else:
                    if 'crafting table' not in seen_entities:
                        return 'go_to table'
                    else:
                        return 'go_to furnace'
            else:
                missing = []
                if inventory.get('wood', 0) < 1:
                    missing.append('wood')
                if inventory.get('stone', 0) < 1:
                    missing.append('stone')
                if inventory.get('coal', 0) < 1:
                    missing.append('coal')
                if inventory.get('iron', 0) < 1:
                    missing.append('iron')
                return f'collect {", ".join(missing)} for iron_pickaxe'
        elif achievement == 'make_iron_sword':
            if inventory.get('wood', 0) >= 1 and inventory.get('stone', 0) >= 1 and inventory.get('coal',
                                                                                                  0) >= 1 and inventory.get(
                'iron', 0) >= 1:
                if 'crafting table' in seen_entities and 'furnace' in seen_entities:
                    return 'craft iron_sword'
                else:
                    if 'crafting table' not in seen_entities:
                        return 'go_to table'
                    else:
                        return 'go_to furnace'
            else:
                missing = []
                if inventory.get('wood', 0) < 1:
                    missing.append('wood')
                if inventory.get('stone', 0) < 1:
                    missing.append('stone')
                if inventory.get('coal', 0) < 1:
                    missing.append('coal')
                if inventory.get('iron', 0) < 1:
                    missing.append('iron')
                return f'collect {", ".join(missing)} for iron_sword'
        elif achievement == 'collect_diamond':
            if 'diamond' in seen_entities:
                if inventory.get('iron pickaxe', 0) > 0:
                    return 'collect diamond'
                else:
                    return 'get_iron_pickaxe_for_diamond'
            else:
                return 'explore to find diamond'
        elif achievement == 'place_stone':
            if inventory.get('stone', 0) >= 1:
                return 'place stone'
            else:
                return 'collect_stone for placing'
        elif achievement == 'place_plant':
            if inventory.get('sapling', 0) >= 1:
                if 'grass' in seen_entities:
                    return 'place plant'
                else:
                    return 'find_grass_for_plant'
            else:
                return 'collect_sapling for plant'
        elif achievement == 'collect_drink':
            if 'water' in seen_entities:
                return 'collect water'
            else:
                return 'explore to find water'
        elif achievement == 'eat_plant':
            if 'ripe plant' in seen_entities:
                return 'collect ripe_plant'
            else:
                if inventory.get('food', 0) > 0:
                    return 'eat'
                else:
                    return 'find_ripe_plant'
        elif achievement == 'eat_cow':
            if 'cow' in seen_entities:
                return 'collect cow'
            else:
                if inventory.get('food', 0) > 0:
                    return 'eat'
                else:
                    return 'find_cow'
        elif achievement == 'defeat_skeleton':
            if 'skeleton' in seen_entities:
                return 'defeat skeleton'
            else:
                return 'explore to find skeleton'
        elif achievement == 'defeat_zombie':
            if 'zombie' in seen_entities:
                return 'defeat zombie'
            else:
                return 'explore to find zombie'
        elif achievement == 'wake_up':
            if state['status'].get('Wakefulness', 100) < 30:
                return 'sleep'
            else:
                return 'wake_up_after_sleep'
        return None


if __name__ == '__main__':
    bestgoal = BestGoal()

    text_state1 = """
        You see: sand, grass, stone, tree, path, crafting table, skeleton
        Inventory: wood pickaxe: 3, stone: 1, wood: 1
        Status: Health: 99%, Fullness: 55%, Hydration: 55%, Wakefulness: 65%, Sky brightness level: 79%
        """
    text_state2 = """
        You see: water, stone, path, tree, sand, plant, crafting table, grass
        Inventory:
        Status: Health: 99%, Fullness: 33%, Hydration: 66%, Wakefulness: 55%, Sky brightness level: 15%
        """
    text_state3 = """
        You see: grass, tree, path, lava, skeletons, coal, stone, crafting table
        Inventory: wood: 1, stone: 1, wood pickaxe: 2, wood sword: 1
        Status: Health: 99%, Fullness: 99%, Hydration: 33%, Wakefulness: 66%, Sky brightness level: 57%
        """
    text_state4 = """
        You see: grass, tree, path, lava, skeletons, coal, stone, crafting table
        Inventory: wood: 2, stone: 1, wood pickaxe: 2, wood sword: 1
        Status: Health: 99%, Fullness: 99%, Hydration: 33%, Wakefulness: 66%, Sky brightness level: 57%
        """
    get_goal = bestgoal.determine_goal(text_state1)
    print(get_goal)
