#!/bin/bash

# pruner Annealing strategies
# SGRL w/ 3-Stage Cos
python train.py --seed 1000 --use_goal --use_wandb --goal_type SGRL --alg_name SGRL_3-Stage_Cos --epsilon_type 3stagecos --clip 0.2 --total_timesteps 1e7
python train.py --seed 10000 --use_goal --use_wandb --goal_type SGRL --alg_name SGRL_3-Stage_Cos --epsilon_type 3stagecos --clip 0.2 --total_timesteps 1e7
python train.py --seed 123 --use_goal --use_wandb --goal_type SGRL --alg_name SGRL_3-Stage_Cos --epsilon_type 3stagecos --clip 0.2 --total_timesteps 1e7
python train.py --seed 1234 --use_goal --use_wandb --goal_type SGRL --alg_name SGRL_3-Stage_Cos --epsilon_type 3stagecos --clip 0.2 --total_timesteps 1e7
python train.py --seed 12345 --use_goal --use_wandb --goal_type SGRL --alg_name SGRL_3-Stage_Cos --epsilon_type 3stagecos --clip 0.2 --total_timesteps 1e7

# SGRL w/ 3-Stage Linear
python train.py --seed 1000 --use_goal --use_wandb --goal_type SGRL --alg_name SGRL_3-Stage_Cos --epsilon_type 3stagelinear --clip 0.2 --total_timesteps 1e7
python train.py --seed 10000 --use_goal --use_wandb --goal_type SGRL --alg_name SGRL_3-Stage_Cos --epsilon_type 3stagelinear --clip 0.2 --total_timesteps 1e7
python train.py --seed 123 --use_goal --use_wandb --goal_type SGRL --alg_name SGRL_3-Stage_Cos --epsilon_type 3stagelinear --clip 0.2 --total_timesteps 1e7
python train.py --seed 1234 --use_goal --use_wandb --goal_type SGRL --alg_name SGRL_3-Stage_Cos --epsilon_type 3stagelinear --clip 0.2 --total_timesteps 1e7
python train.py --seed 12345 --use_goal --use_wandb --goal_type SGRL --alg_name SGRL_3-Stage_Cos --epsilon_type 3stagelinear --clip 0.2 --total_timesteps 1e7

# SGRL w/ Exp Ann
python train.py --seed 1000 --use_goal --use_wandb --goal_type SGRL --alg_name SGRL_3-Stage_Cos --epsilon_type expann --clip 0.2 --total_timesteps 1e7
python train.py --seed 10000 --use_goal --use_wandb --goal_type SGRL --alg_name SGRL_3-Stage_Cos --epsilon_type expann --clip 0.2 --total_timesteps 1e7
python train.py --seed 123 --use_goal --use_wandb --goal_type SGRL --alg_name SGRL_3-Stage_Cos --epsilon_type expann --clip 0.2 --total_timesteps 1e7
python train.py --seed 1234 --use_goal --use_wandb --goal_type SGRL --alg_name SGRL_3-Stage_Cos --epsilon_type expann --clip 0.2 --total_timesteps 1e7
python train.py --seed 12345 --use_goal --use_wandb --goal_type SGRL --alg_name SGRL_3-Stage_Cos --epsilon_type expann --clip 0.2 --total_timesteps 1e7

# SGRL w/ Linear Ann
python train.py --seed 1000 --use_goal --use_wandb --goal_type SGRL --alg_name SGRL_3-Stage_Cos --epsilon_type linearann --clip 0.2 --total_timesteps 1e7
python train.py --seed 10000 --use_goal --use_wandb --goal_type SGRL --alg_name SGRL_3-Stage_Cos --epsilon_type linearann --clip 0.2 --total_timesteps 1e7
python train.py --seed 123 --use_goal --use_wandb --goal_type SGRL --alg_name SGRL_3-Stage_Cos --epsilon_type linearann --clip 0.2 --total_timesteps 1e7
python train.py --seed 1234 --use_goal --use_wandb --goal_type SGRL --alg_name SGRL_3-Stage_Cos --epsilon_type linearann --clip 0.2 --total_timesteps 1e7
python train.py --seed 12345 --use_goal --use_wandb --goal_type SGRL --alg_name SGRL_3-Stage_Cos --epsilon_type linearann --clip 0.2 --total_timesteps 1e7

# baseline
# PPO
python train.py --seed 1000 --use_wandb --alg_name PPO --clip 0.2 --total_timesteps 1e7
python train.py --seed 10000 --use_wandb --alg_name PPO --clip 0.2 --total_timesteps 1e7
python train.py --seed 123 --use_wandb --alg_name PPO --clip 0.2 --total_timesteps 1e7
python train.py --seed 1234 --use_wandb --alg_name PPO --clip 0.2 --total_timesteps 1e7
python train.py --seed 12345 --use_wandb --alg_name PPO --clip 0.2 --total_timesteps 1e7

# ELLM
python train.py --seed 1000 --use_goal --use_wandb --goal_type LM --alg_name ELLM --lm_name deepseek-chat --clip 0.2 --total_timesteps 1e7
python train.py --seed 10000 --use_goal --use_wandb --goal_type LM --alg_name ELLM --lm_name deepseek-chat --clip 0.2 --total_timesteps 1e7
python train.py --seed 123 --use_goal --use_wandb --goal_type LM --alg_name ELLM --lm_name deepseek-chat --clip 0.2 --total_timesteps 1e7
python train.py --seed 1234 --use_goal --use_wandb --goal_type LM --alg_name ELLM --lm_name deepseek-chat --clip 0.2 --total_timesteps 1e7
python train.py --seed 12345 --use_goal --use_wandb --goal_type LM --alg_name ELLM --lm_name deepseek-chat --clip 0.2 --total_timesteps 1e7

# AdaRefiner
python train.py --seed 1000 --use_goal --use_wandb --goal_type LM --alg_name AdaRefiner --lm_name deepseek-chat --clip 0.2 --total_timesteps 1e7
python train.py --seed 10000 --use_goal --use_wandb --goal_type LM --alg_name AdaRefiner --lm_name deepseek-chat --clip 0.2 --total_timesteps 1e7
python train.py --seed 123 --use_goal --use_wandb --goal_type LM --alg_name AdaRefiner --lm_name deepseek-chat --clip 0.2 --total_timesteps 1e7
python train.py --seed 1234 --use_goal --use_wandb --goal_type LM --alg_name AdaRefiner --lm_name deepseek-chat --clip 0.2 --total_timesteps 1e7
python train.py --seed 12345 --use_goal --use_wandb --goal_type LM --alg_name AdaRefiner --lm_name deepseek-chat --clip 0.2 --total_timesteps 1e7

# Ablation Variants
# SGRL w/ Static-Prun
python train.py --seed 1000 --use_goal --use_wandb --goal_type SGRL --alg_name SGRL_3-Stage_Cos --epsilon_type 3stagecos --epsilon 1e-6 --clip 0.2 --total_timesteps 1e7
python train.py --seed 10000 --use_goal --use_wandb --goal_type SGRL --alg_name SGRL_3-Stage_Cos --epsilon_type 3stagecos --epsilon 1e-6 --clip 0.2 --total_timesteps 1e7
python train.py --seed 123 --use_goal --use_wandb --goal_type SGRL --alg_name SGRL_3-Stage_Cos --epsilon_type 3stagecos --epsilon 1e-6 --clip 0.2 --total_timesteps 1e7
python train.py --seed 1234 --use_goal --use_wandb --goal_type SGRL --alg_name SGRL_3-Stage_Cos --epsilon_type 3stagecos --epsilon 1e-6 --clip 0.2 --total_timesteps 1e7
python train.py --seed 12345 --use_goal --use_wandb --goal_type SGRL --alg_name SGRL_3-Stage_Cos --epsilon_type 3stagecos --epsilon 1e-6 --clip 0.2 --total_timesteps 1e7

# SGRL w/o Prun
python train.py --seed 1000 --use_goal --use_wandb --goal_type SGRL --alg_name SGRL_3-Stage_Cos --epsilon_type 3stagecos --min_epsilon 1 -clip 0.2 --total_timesteps 1e7
python train.py --seed 10000 --use_goal --use_wandb --goal_type SGRL --alg_name SGRL_3-Stage_Cos --epsilon_type 3stagecos --min_epsilon 1 --clip 0.2 --total_timesteps 1e7
python train.py --seed 123 --use_goal --use_wandb --goal_type SGRL --alg_name SGRL_3-Stage_Cos --epsilon_type 3stagecos --min_epsilon 1 --clip 0.2 --total_timesteps 1e7
python train.py --seed 1234 --use_goal --use_wandb --goal_type SGRL --alg_name SGRL_3-Stage_Cos --epsilon_type 3stagecos --min_epsilon 1 --clip 0.2 --total_timesteps 1e7
python train.py --seed 12345 --use_goal --use_wandb --goal_type SGRL --alg_name SGRL_3-Stage_Cos --epsilon_type 3stagecos --min_epsilon 1 --clip 0.2 --total_timesteps 1e7

# SGRL w/o Priority
python train.py --seed 1000 --use_goal --use_wandb --goal_type SGRL_nopri --alg_name SGRL_3-Stage_Cos --epsilon_type 3stagecos --clip 0.2 --total_timesteps 1e7
python train.py --seed 10000 --use_goal --use_wandb --goal_type SGRL_nopri --alg_name SGRL_3-Stage_Cos --epsilon_type 3stagecos --clip 0.2 --total_timesteps 1e7
python train.py --seed 123 --use_goal --use_wandb --goal_type SGRL_nopri --alg_name SGRL_3-Stage_Cos --epsilon_type 3stagecos --clip 0.2 --total_timesteps 1e7
python train.py --seed 1234 --use_goal --use_wandb --goal_type SGRL_nopri --alg_name SGRL_3-Stage_Cos --epsilon_type 3stagecos --clip 0.2 --total_timesteps 1e7
python train.py --seed 12345 --use_goal --use_wandb --goal_type SGRL_nopri --alg_name SGRL_3-Stage_Cos --epsilon_type 3stagecos --clip 0.2 --total_timesteps 1e7


