# PIPS Code Submission

This repository contains the code and scripts for the experiments in the "Per-Instance Program Synthesis" submission.

## Environment Setup

1. Create and activate a Python virtual environment:

   ```bash
   make create_environment
   source .venv/bin/activate
   ```

2. Install dependencies:

   ```bash
   make requirements
   ```

## Running Experiments

All experiments are launched via the `scripts/run_experiments.py` script. For example:

```bash
python scripts/run_experiments.py \
    --dataset bbeh_word_sorting \
    --model gemini-2.0-flash \
    --method zs_cot \
    --num_gen 1 \
    --temperature 0.0
```

The possible methods are `zs_cot` for CoT, `code` for PoT, and
`gen_sym_reason_prog_checks` for PIPS.

Use `--help` to see all available options:

```bash
python scripts/run_experiments.py --help
```

Results will be written to the `logs/` directory (e.g., `logs/{model}/{dataset}/{method}`).

## Experiment Logs

We include model outputs and other logs from all experiments included in the
paper in the `logs/` directory. These logs are enough to recreate all plots in
the paper using the `scripts/plot_main_result.ipynb`.