#!/bin/bash
# run_parallel_experiments.sh
#
# Usage: ./run_parallel_experiments.sh <model> <dataset>
#
# This script launches multiple experiment commands in parallel.
# Each command logs its output to a file in launch_logs/{model}/{dataset}/{method}.txt.

# Check if both parameters are provided
if [ "$#" -ne 2 ]; then
    echo "Usage: $0 <model> <dataset>"
    exit 1
fi

MODEL="$1"
DATASET="$2"

# Define the list of methods to run
methods=("gen_sym_reason_prog" "zs_cot" "gen_sym_prog" "gen_sym" "code")  #"gen_task_prog" )

# Initialize conda; adjust the path below if needed
source "$(conda info --base)/etc/profile.d/conda.sh"
conda activate unesy

# Loop through each method and launch the experiment in the background
for method in "${methods[@]}"; do
    # Create the full log directory (model/dataset)
    log_dir="launch_logs/${MODEL}/${DATASET}"
    mkdir -p "${log_dir}"
    
    # Construct the log file name
    log_file="${log_dir}/${method}.txt"
    
    echo "Launching method ${method} with model ${MODEL} and dataset ${DATASET}. Logging to ${log_file}..."
    
    # Launch the experiment in the background; stdout and stderr go to the log file
    python scripts/run_experiments.py --method "${method}" --model "${MODEL}" --log --dataset "${DATASET}" > "${log_file}" 2>&1 &
done

# Wait for all background processes to complete
wait

echo "All experiments have completed."
