
# Learning Disentangled Representations in Fairness with Limited Demographics

This repository contains the code for producing the results in our submission "Learning Disentangled Representations in Fairness with Limited Demographics".

## Installation

1. **Install Conda:** Follow the instructions on the official Conda website to install Conda.

## Creating and Activating the Conda Environment

- **Create the Conda Environment:**
  ```bash
  conda env create -f environment.yml
  ```
- **Activate the Conda Environment:**
  ```bash
  conda activate Env
  ```

## Usage Instructions

### CelebA Dataset

1. **Prepare the Dataset:**
   - Download the CelebA dataset and place it in your root directory.
   - Create a directory named `celeba`.

2. **Run the Code:**
   - Navigate to the CelebA directory:
     ```bash
     cd CelebA
     ```
   - Execute the first step of representation learning:
     ```bash
     python Step_1_Representation_learning.py
     ```
   - After completing the first step, run the Jupyter notebooks:
     - `Step_2_Extract_dataset.ipynb`
     - `python Step_3_Fair_classifier.py`

### UTKFace Dataset

1. **Prepare the Dataset:**
   - Download the UTKFace dataset from [this link](https://susanqq.github.io/UTKFace/) and place it in your root directory.
   - Create a directory named `UTKFace`.

2. **Run the Code:**
   - Navigate to the UTKFace directory:
     ```bash
     cd UTKFace
     ```
   - Execute the first step of representation learning:
     ```bash
     python Step_1_Representation_learning.py
     ```
   - Continue with the subsequent Jupyter notebooks:
     - `Step_2_extract_dataset.ipynb`
     - `python Step_3_fair_classifier.py`

### Adult Dataset

- The Adult dataset is provided in the `Adult` folder.
- Navigate to the Adult directory and run the Jupyter notebooks:
  ```bash
  cd Adult
  ```
  - `Step_1_Representation_Learning.ipynb`
  - `Step_2_Fair_classifier_Adult.ipynb`

