
import numpy as np
import matplotlib.pyplot as plt

eval_acc_traineps030 = np.asarray([[0.1069,1 , 1, 1, 1],[0.0981,1,1,1,1]])
eval_acc_traineps035 = np.asarray([[0.0876, 0.1213, 1, 1, 1],[0.0855,0.1204,1,1,1]])
eval_acc_traineps040 = np.asarray([[0.0862, 0.1140, 0.1582, 1, 1],[0.0835,0.1102,0.1488,1,1]])
eval_acc_traineps045 = np.asarray([[0.2513, 0.3062, 0.3763, 0.4788, 1]]) #[0.0945, 0.1209, 0.1598, 0.2230, 1],
eval_acc_traineps050 = np.asarray([[0.6793,0.8702,0.9165,0.9183,0.9208]])


eps = np.asarray([0.3,0.35,0.4,0.45,0.5])
fig = plt.figure(figsize=(11.3, 8.1), facecolor='white', dpi=300)
fig.add_subplot(1, 1, 1, frameon=True) 
for i,data in enumerate([eval_acc_traineps030, eval_acc_traineps035, eval_acc_traineps040, eval_acc_traineps045, eval_acc_traineps050]):
    mean = np.mean(data, axis=0)
    std = np.std(data, axis=0)*10

    plt.errorbar(eps, mean, std, fmt='-o')
    if i >= 2:
        break

fig.savefig('./margin/'+ 'differenttraineps.png')