## Copyright (C) 2019, Huan Zhang <huan@huan-zhang.com>
##                     Hongge Chen <chenhg@mit.edu>
##                     Chaowei Xiao <xiaocw@umich.edu>
## 
## This program is licenced under the BSD 2-Clause License,
## contained in the LICENCE file in this directory.
##
import sys
import copy
import torch
import numpy as np
from bound_layers import BoundSequential
# from gpu_profile import gpu_profile
import time
from datetime import datetime
from eps_scheduler import EpsilonScheduler
from config import load_config, get_path, config_modelloader, config_dataloader_index, config_dataloader
from argparser import argparser
from train import Train, Logger
import matplotlib.pyplot as plt
import matplotlib
# sys.settrace(gpu_profile)
length = 60
DPI = 300
matplotlib.rc('xtick', labelsize=20) 
matplotlib.rc('ytick', labelsize=20) 
# matplotlib.rc('xlabel', labelsize=20) 
# matplotlib.rc('ylabel', labelsize=20) 
fig = plt.figure(figsize=(11.3, 8.1), facecolor='white', dpi=DPI)
fig.add_subplot(1, 1, 1, frameon=True) 
# plt.rc('axes', color_cycle=['r', 'g', 'b', 'y'])
plt.ylim(0,1500)
plt.xlabel('Margin', fontsize=20)
plt.ylabel('Frequency', fontsize=20)
count = 0
for model_id in ["job90_cifar_dm-large_16_255_train24_255-IBP", "job158_cifar_dm-large_16_255_train24_255-IBP_autoeps6_5"]:
# for model_id in ["job20_mnist_dm-large_0.4-IBP_standard", "job83_mnist_dm-large_0.4-IBP_standard_weight2_3"]:
    margin_record = np.load('./margin/'+ model_id+'.npy')
    if count == 0:
        plt.hist(margin_record, bins = np.linspace(-1,1,201),alpha = 0.4,color='r', label="vanilla") 
    else:
        plt.hist(margin_record, bins = np.linspace(-1,1,201),alpha = 0.4,color='b', label="re-weight") 
    count += 1
fig.legend(fontsize=20,loc=3, bbox_to_anchor=(0.6,0.5))
fig.savefig('./margin/'+ 'margin_compare33'+'.png')
