import pandas as pd
import torch
import torch.nn.parallel
import torch.optim
import torch.utils.data
import torch.utils.data.distributed
from PIL import Image
from torch.utils.data import Dataset

dataroot = ''


def default_loader(path: str):
    from torchvision import get_image_backend
    if get_image_backend() == 'accimage':
        return accimage_loader(path)
    else:
        return pil_loader(path)


def pil_loader(path: str) -> Image.Image:
    # open path as file to avoid ResourceWarning (https://github.com/python-pillow/Pillow/issues/835)
    with open(path, 'rb') as f:
        img = Image.open(f)
        return img.convert('RGB')


# TODO: specify the return type
def accimage_loader(path: str):
    import accimage
    try:
        return accimage.Image(path)
    except IOError:
        # Potentially a decoding problem, fall back to PIL.Image
        return pil_loader(path)


class CGLM(Dataset):
    def __init__(self, csv_file, task, is_train=False, transform=None, timefile=None):
        self.data = pd.read_csv(csv_file, header=None, names=["class_id", "image_path", 'time'])
        self.transform = transform
        self.nb_classes = 10788
        if not is_train:
            self.get_test_data(task, timefile)

    def get_test_data(self, task, timefile):
        with open(timefile) as file:
            lines = file.readlines()
            task_time = float(lines[task].strip())
        self.data = self.data[self.data.iloc[:, 2] <= task_time]

    def __len__(self):
        return len(self.data)

    def __getitem__(self, idx):
        if torch.is_tensor(idx):
            idx = idx.item()

        class_id = int(self.data.iloc[idx, 0])

        image_path = self.data.iloc[idx, 1]
        path = f"{dataroot}/{image_path}"

        image = default_loader(path)
        if self.transform:
            image = self.transform(image)

        return image, class_id
