import os
import argparse
parser = argparse.ArgumentParser(description='Get ImageNet benchmark')
parser.add_argument('--root1k', default='', metavar='DIR', help='ImageNet 1k dataroot')
parser.add_argument('--root21k', default='', metavar='DIR', help='ImageNet 21k dataroot')
parser.add_argument('--benchmark', default='ImageNet10k', metavar='DIR', help='Path to save benchmark')
parser.add_argument('--dataset', default='ImageNet10k', choices=['ImageNet10k','ImageNet2k'], help='whcih dataset to build')
args = parser.parse_args()
def symlink_force(target, link_name):
    try:
        os.symlink(target, link_name)
    except FileExistsError:
        pass


i1k = args.root1k
i21k_root = args.root21k
i21k = f'{i21k_root}/train'
i1k_cls = set(os.listdir(i1k))
i21k_cls = set(os.listdir(i21k))

# Get unique classes
if args.dataset == 'ImageNet10k':
    classes = i21k_cls - i1k_cls
elif args.dataset == 'ImageNet2k':
    with open('1kunique.txt', 'r') as f:
        classes = [cls.strip() for cls in f.readlines()]
        classes += i1k_cls
else:
    raise Error

data_root = args.benchmark
os.makedirs(f'{data_root}/train', exist_ok=True)
os.makedirs(f'{data_root}/val', exist_ok=True)

for c in classes:
    symlink_force(f'{i21k_root}/train/{c}', f'{data_root}/train/{c}')
    symlink_force(f'{i21k_root}/val/{c}', f'{data_root}/val/{c}')
