# Copyright (c) Meta Platforms, Inc. and affiliates.
# All rights reserved.

# This source code is licensed under the license found in the
# LICENSE file in the root directory of this source tree.

import math

def adjust_learning_rate(optimizer, epoch, args, total_iter=None,base_lr=None):
    """Decay the learning rate with half-cycle cosine after warmup"""

    if base_lr== None:
        blr = args.lr
    else:
        blr = base_lr

    warmup_epochs = args.warmup
    min_lr = args.min_lr
    if total_iter is None:
        total_iter = args.iters
    if blr < min_lr:
        min_lr = blr / 2





    if epoch < warmup_epochs:
        lr = blr * epoch / warmup_epochs
    else:
        lr = min_lr + (blr - min_lr) * 0.5 * \
            (1. + math.cos(math.pi * (epoch - warmup_epochs) / (total_iter - warmup_epochs)))
    for param_group in optimizer.param_groups:
        if "lr_scale" in param_group:
            param_group["lr"] = lr * param_group["lr_scale"]
        else:
            param_group["lr"] = lr

    return lr
