from dataclasses import dataclass, field
from typing import Union, Optional
import simpy


@dataclass(frozen=True)
class Message:
    timestamp: float = field(init=False)
    content: str
    sender: int = field(init=False)
    recipient: int = field(init=False)
    comm_type: str = field(init=False, default=None)

    def __init__(
        self,
        env: simpy.Environment,
        content: str,
        sender: Union[int, str],
        recipient: Union[int, str],
        comm_type: Optional[str] = None,
    ) -> None:
        # 1) record sim time
        ts = env.now

        # 2) coerce sender/recipient to ints
        if isinstance(sender, str) and ":" in sender:
            sender = int(sender.split(":", 1)[0])
        if isinstance(recipient, str) and ":" in recipient:
            recipient = int(recipient.split(":", 1)[0])
        sender_int = sender
        recipient_int = recipient

        # 3) assign to frozen fields
        object.__setattr__(self, "timestamp", ts)
        object.__setattr__(self, "content", content)
        object.__setattr__(self, "sender", sender_int)
        object.__setattr__(self, "recipient", recipient_int)
        object.__setattr__(self, "comm_type", comm_type)
