from ..actors.actor import Actor


class RegulatoryAgency(Actor):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        # Additional initialization for RegulatoryAgency if needed
        self.info(
            f"{self.org_role} create with allowed tools: {list(self.tools.keys())}"
        )

    @property
    def org_role(self) -> str:
        return "Regulatory Agency"

    @property
    def system_message(self) -> str:
        return (
            "You are a regulatory agency overseeing clinical trials.\n"
            "Your role is to review application for phase III clinical trial program.\n"
            "When receiving an application, provide feedback on its strengths and weaknesses. Verify that all the necessary elements are included.\n"
            "Offer guidance on how to improve the application if needed.\n"
            "Keep all communications short and to the point. Never lie or make up false information.\n"
        )
