from enum import Enum
from dataclasses import dataclass, field
from typing import Optional


class TaskStatus(str, Enum):
    NOT_STARTED = "Not started"
    IN_PROGRESS = "In progress"
    COMPLETED = "Completed"


@dataclass
class Task:
    _id: int
    name: str
    description: str
    relies_on: list[int] = field(
        default_factory=list
    )  # the IDs of other tasks that must be completed first
    status: TaskStatus = TaskStatus.NOT_STARTED
    mandatory: bool = False
    started_by: Optional[int] = None  # actor_id who started
    completed_by: Optional[int] = None  # actor_id who completed
    phase: str = "A"

    def mark_started(self, actor_id: int):
        if self.status == TaskStatus.NOT_STARTED:
            self.status = TaskStatus.IN_PROGRESS
            self.started_by = actor_id

    def mark_completed(self, actor_id: int):
        self.status = TaskStatus.COMPLETED
        self.completed_by = actor_id
