from .plan import PlanPolicy
from .LLM import LLMPolicy
from .player import PlayerPolicy
from .Local_LLM import LocalLLMPolicy


def initialise_policy(policy_name):
    policy_name, arg = (
        policy_name.split(":")[0],
        policy_name.split(":")[1] if ":" in policy_name else None,
    )

    if policy_name == "PlanPolicy":
        return PlanPolicy(level=int(arg) if arg is not None else 3)
    elif policy_name == "LLMPolicy":
        return LLMPolicy()
    elif policy_name == "PlayerPolicy":
        return PlayerPolicy()
    elif policy_name == "LocalLLMPolicy":
        return LocalLLMPolicy()
    else:
        raise ValueError(f"Unknown policy: {policy_name}")
