import ast


class PlayerPolicy:
    def __init__(self):
        self.log_action_obs = []
        self.plan = [
            "{'Investigator:1': (1,[]), 'Sponsor:2': (0,[]), 'Legal Team:3': (0,[]), 'Statistician:4': (0,[])}",
            "0,0,0,0",
            "0,0,0,0",
            "0,0,0,0",
            "{'Investigator:1': (3,['2']), 'Sponsor:2': (0,[]), 'Legal Team:3': (0,[]), 'Statistician:4': (0,[])}",
            "{'Investigator:1': (0,[]), 'Sponsor:2': (1,[]), 'Legal Team:3': (0,[]), 'Statistician:4': (0,[])}",
            "0,0,0,0",
            "0,0,0,0",
            "0,0,0,0",
            "{'Investigator:1': (0,[]), 'Sponsor:2': (3,['1']), 'Legal Team:3': (0,[]), 'Statistician:4': (0,[])}",
            "{'Investigator:1': (1,[]), 'Sponsor:2': (0,[]), 'Legal Team:3': (0,[]), 'Statistician:4': (0,[])}",
        ]

    def select_action(self, state, env):
        if env.simulation.env.now < env.wait_time:
            action_str = ""

        elif env.simulation.env.now < len(self.plan):
            action_str = self.plan[int(env.simulation.env.now)]
        else:
            action_str = input("Enter action: ")

        if action_str == "p":
            action_str = str(
                {
                    f"{actor.org_role}:{actor.actor_id}": (0, [])
                    for actor in env.simulation.actors
                }
            )

        if action_str == "":
            return env.prev_action

        if "!" in action_str:
            # If the action string contains '!', split it into action and time
            action_str, time = action_str.split("!", 1)
            env.wait_time = env.simulation.env.now + int(time.strip())

        if action_str != "0,0,0,0":
            self.log_action_obs.append(state)
            self.log_action_obs.append(action_str)
        try:
            action = ast.literal_eval(action_str)
            assert (
                isinstance(action, dict)
                or isinstance(action, list)
                or isinstance(action, tuple)
                or action_str == "0,0,0,0"
            )
            if action_str != "0,0,0,0":
                env.is_valid(action)
        except Exception:
            action = self.select_action(state, env)
        env.prev_action = action
        return action

    def reset(self):
        self.log_action_obs = []
