#!/bin/bash
set -euo pipefail

FILES=(
  "organisation/data/clinical_trial/incentives/incentives_0.json"
  "organisation/data/clinical_trial/incentives/incentives_1.json"
  "organisation/data/clinical_trial/incentives/incentives_2.json"
  "organisation/data/clinical_trial/incentives/incentives_3.json"
  "organisation/data/clinical_trial/incentives/incentives_4.json"
  "organisation/data/clinical_trial/incentives/incentives_5.json"
  "organisation/data/clinical_trial/incentives/incentives_6.json"
  "organisation/data/clinical_trial/incentives/incentives_7.json"
  "organisation/data/clinical_trial/incentives/incentives_8.json"
  "organisation/data/clinical_trial/incentives/incentives_9.json"
  "organisation/data/clinical_trial/incentives/incentives_10.json"
  "organisation/data/clinical_trial/incentives/incentives_11.json"
  "organisation/data/clinical_trial/incentives/incentives_12.json"
  "organisation/data/clinical_trial/incentives/incentives_13.json"
)

for i in "${!FILES[@]}"; do
  idx=$((i+1))
    echo -e "\n\n===== FILE $idx/${#FILES[@]} • — INCENTIVES_FILE=${FILES[$i]} =====\n"

    if ! INCENTIVES_FILE="${FILES[$i]}" python organisation/env/run_policy.py --parallel --incentives; then
      status=$?
      echo "⚠️  Run failed for ${FILES[$i]} with exit code $status — continuing to next run..."
      continue
    fi
done
