# TAIA

This repository contains scripts for reproducing TAIA

## Install

```bash
pip install -e ".[train]"
pip install flash-attn --no-build-isolation
```

## Train & Evaluate 
We take training a LLaMA2 model with AlpacaGPT4 as an example.
For other datasets or base LLMs, please just replace the `conv_mode` and `prompt_type` from `llama2` to the specific type `qwen` or `llama3` and prepare the cot-collection dataset, OpenMath or Medical-Collection. 


### Training Commands
Please replace the llama2 checkpoint directory and save directory as your own in `scripts/v1/sft_alapca_lora_7b_llama.sh`
Then run the following commands:
```bash
sbatch scripts/v1/sft_alapca_lora_7b_llama.sh
```

### Evaluating Commands
After the training process done, check the save directory in `scripts/v1/eval/main_lora_woffn.sh` and run the following commands:
```bash
bash scripts/v1/eval/main_lora_woffn.sh $CKPT_NAME
```
This command will save all generated contents as well as the inference process into `logs/diverse/${domain}` folder.
And just check the file `logs/diverse/${domain}/${CKPT_NAME}-woffn.eval.log` to see the final results


