import subprocess
import pandas as pd
from io import StringIO


def summary(plan_name):
    ducttape = subprocess.Popen(["ducttape", "main.tape", "-C", "main.tconf", "-p", plan_name, "summary"], stdout=subprocess.PIPE)
    tabular = subprocess.Popen(['tabular'], stdin=ducttape.stdout, stdout=subprocess.PIPE)
    csv = subprocess.check_output(["grep", "-o", "^[^#]*"], stdin=tabular.stdout).decode('ascii')

    return pd.read_csv(StringIO(csv), sep="\s+")
